/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.FormatUtils;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.UpdateCenter;
import org.sonar.updatecenter.common.Version;

public final class UpdateCenterDeserializer {
    private UpdateCenterDeserializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateCenter fromProperties(File file) throws IOException {
        FileInputStream in = FileUtils.openInputStream((File)file);
        try {
            Properties props = new Properties();
            props.load(in);
            UpdateCenter center = UpdateCenterDeserializer.fromProperties(props);
            center.setDate(new Date(file.lastModified()));
            UpdateCenter updateCenter = center;
            return updateCenter;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static UpdateCenter fromProperties(Properties p) {
        String[] pluginKeys;
        String[] sonarVersions;
        UpdateCenter center = new UpdateCenter();
        center.setDate(FormatUtils.toDate(p.getProperty("date"), true));
        for (String sonarVersion : sonarVersions = UpdateCenterDeserializer.getArray(p, "sonar.versions")) {
            Release release = new Release((Artifact)center.getSonar(), sonarVersion);
            release.setChangelogUrl(UpdateCenterDeserializer.get(p, "sonar." + sonarVersion + ".changelogUrl"));
            release.setDescription(UpdateCenterDeserializer.get(p, "sonar." + sonarVersion + ".description"));
            release.setDownloadUrl(UpdateCenterDeserializer.get(p, "sonar." + sonarVersion + ".downloadUrl"));
            release.setDate(FormatUtils.toDate(UpdateCenterDeserializer.get(p, "sonar." + sonarVersion + ".date"), false));
            center.getSonar().addRelease(release);
        }
        for (String pluginKey : pluginKeys = UpdateCenterDeserializer.getArray(p, "plugins")) {
            String[] pluginReleases;
            Plugin plugin = new Plugin(pluginKey);
            center.addPlugin(plugin);
            plugin.setName(UpdateCenterDeserializer.get(p, pluginKey, "name"));
            plugin.setDescription(UpdateCenterDeserializer.get(p, pluginKey, "description"));
            plugin.setCategory(UpdateCenterDeserializer.get(p, pluginKey, "category"));
            plugin.setHomepageUrl(UpdateCenterDeserializer.get(p, pluginKey, "homepageUrl"));
            plugin.setLicense(UpdateCenterDeserializer.get(p, pluginKey, "license"));
            plugin.setOrganization(UpdateCenterDeserializer.get(p, pluginKey, "organization"));
            plugin.setOrganizationUrl(UpdateCenterDeserializer.get(p, pluginKey, "organizationUrl"));
            plugin.setTermsConditionsUrl(UpdateCenterDeserializer.get(p, pluginKey, "termsConditionsUrl"));
            plugin.setIssueTrackerUrl(UpdateCenterDeserializer.get(p, pluginKey, "issueTrackerUrl"));
            for (String pluginVersion : pluginReleases = StringUtils.split((String)StringUtils.defaultIfEmpty((String)UpdateCenterDeserializer.get(p, pluginKey, "versions"), (String)""), (String)",")) {
                String[] requiredSonarVersions;
                Release release = new Release((Artifact)plugin, pluginVersion);
                plugin.addRelease(release);
                release.setDownloadUrl(UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".downloadUrl"));
                release.setChangelogUrl(UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".changelogUrl"));
                release.setDescription(UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".description"));
                release.setDate(FormatUtils.toDate(UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".date"), false));
                for (String requiredSonarVersion : requiredSonarVersions = StringUtils.split((String)StringUtils.defaultIfEmpty((String)UpdateCenterDeserializer.get(p, pluginKey, pluginVersion + ".requiredSonarVersions"), (String)""), (String)",")) {
                    release.addRequiredSonarVersions(Version.create(requiredSonarVersion));
                }
            }
        }
        return center;
    }

    private static String get(Properties props, String key) {
        return StringUtils.defaultIfEmpty((String)props.getProperty(key), null);
    }

    private static String[] getArray(Properties props, String key) {
        return StringUtils.split((String)StringUtils.defaultIfEmpty((String)props.getProperty(key), (String)""), (String)",");
    }

    private static String get(Properties p, String pluginKey, String field) {
        return UpdateCenterDeserializer.get(p, pluginKey + "." + field);
    }
}

