/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.UriReader;

public class HttpDownloader
extends UriReader.SchemeProcessor
implements BatchComponent,
ServerComponent {
    public static final int TIMEOUT_MILLISECONDS = 20000;
    private final BaseHttpDownloader downloader;

    public HttpDownloader(Server server, Settings settings) {
        this.downloader = new BaseHttpDownloader(settings.getProperties(), server.getVersion());
    }

    public HttpDownloader(Settings settings) {
        this.downloader = new BaseHttpDownloader(settings.getProperties(), null);
    }

    @Override
    String description(URI uri) {
        return String.format("%s (%s)", uri.toString(), this.getProxySynthesis(uri));
    }

    @Override
    String[] getSupportedSchemes() {
        return new String[]{"http", "https"};
    }

    @Override
    byte[] readBytes(URI uri) {
        return this.download(uri);
    }

    @Override
    String readString(URI uri, Charset charset) {
        try {
            return CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier(this.downloader.newInputSupplier(uri), (Charset)charset));
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    public String downloadPlainText(URI uri, String encoding) {
        return this.readString(uri, Charset.forName(encoding));
    }

    public byte[] download(URI uri) {
        try {
            return ByteStreams.toByteArray(this.downloader.newInputSupplier(uri));
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    public String getProxySynthesis(URI uri) {
        return this.downloader.getProxySynthesis(uri);
    }

    public InputStream openStream(URI uri) {
        try {
            return (InputStream)this.downloader.newInputSupplier(uri).getInput();
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    public void download(URI uri, File toFile) {
        try {
            Files.copy(this.downloader.newInputSupplier(uri), (File)toFile);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)toFile);
            throw this.failToDownload(uri, e);
        }
    }

    private SonarException failToDownload(URI uri, IOException e) {
        throw new SonarException(String.format("Fail to download: %s (%s)", uri, this.getProxySynthesis(uri)), e);
    }

    public static class HttpException
    extends RuntimeException {
        private final URI uri;
        private final int responseCode;

        public HttpException(URI uri, int responseCode) {
            super("Fail to download [" + uri + "]. Response code: " + responseCode);
            this.uri = uri;
            this.responseCode = responseCode;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public URI getUri() {
            return this.uri;
        }
    }

    public static class BaseHttpDownloader {
        private static final List<String> PROXY_SETTINGS = ImmutableList.of((Object)"http.proxyHost", (Object)"http.proxyPort", (Object)"http.nonProxyHosts", (Object)"http.auth.ntlm.domain", (Object)"socksProxyHost", (Object)"socksProxyPort");
        private String userAgent;

        public BaseHttpDownloader(Map<String, String> settings, String userAgent) {
            this.initProxy(settings);
            this.initUserAgent(userAgent);
        }

        private void initProxy(Map<String, String> settings) {
            this.propagateProxySystemProperties(settings);
            if (this.requiresProxyAuthentication(settings)) {
                this.registerProxyCredentials(settings);
            }
        }

        private void initUserAgent(String sonarVersion) {
            this.userAgent = sonarVersion == null ? "Sonar" : String.format("Sonar %s", sonarVersion);
            System.setProperty("http.agent", this.userAgent);
        }

        private String getProxySynthesis(URI uri) {
            return BaseHttpDownloader.getProxySynthesis(uri, ProxySelector.getDefault());
        }

        @VisibleForTesting
        static String getProxySynthesis(URI uri, ProxySelector proxySelector) {
            List<Proxy> proxies = proxySelector.select(uri);
            if (proxies.size() == 1 && proxies.get(0).type().equals((Object)Proxy.Type.DIRECT)) {
                return "no proxy";
            }
            ArrayList descriptions = Lists.newArrayList();
            for (Proxy proxy : proxies) {
                if (proxy.type() == Proxy.Type.DIRECT) continue;
                descriptions.add("proxy: " + proxy.address());
            }
            return Joiner.on((String)", ").join((Iterable)descriptions);
        }

        private void registerProxyCredentials(Map<String, String> settings) {
            Authenticator.setDefault(new ProxyAuthenticator(settings.get("http.proxyUser"), settings.get("http.proxyPassword")));
        }

        private boolean requiresProxyAuthentication(Map<String, String> settings) {
            return settings.containsKey("http.proxyUser");
        }

        private void propagateProxySystemProperties(Map<String, String> settings) {
            for (String key : PROXY_SETTINGS) {
                if (!settings.containsKey(key)) continue;
                System.setProperty(key, settings.get(key));
            }
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri) {
            return new HttpInputSupplier(uri, this.userAgent, null, null);
        }

        public InputSupplier<InputStream> newInputSupplier(URI uri, String login, String password) {
            return new HttpInputSupplier(uri, this.userAgent, login, password);
        }

        private static class ProxyAuthenticator
        extends Authenticator {
            private final PasswordAuthentication auth;

            ProxyAuthenticator(String user, String password) {
                this.auth = new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
            }

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return this.auth;
            }
        }

        private static class HttpInputSupplier
        implements InputSupplier<InputStream> {
            private final String login;
            private final String password;
            private final URI uri;
            private final String userAgent;

            HttpInputSupplier(URI uri, String userAgent, String login, String password) {
                this.uri = uri;
                this.userAgent = userAgent;
                this.login = login;
                this.password = password;
            }

            public InputStream getInput() throws IOException {
                LoggerFactory.getLogger(this.getClass()).debug("Download: " + this.uri + " (" + BaseHttpDownloader.getProxySynthesis(this.uri, ProxySelector.getDefault()) + ")");
                HttpURLConnection connection = (HttpURLConnection)this.uri.toURL().openConnection();
                if (!Strings.isNullOrEmpty((String)this.login)) {
                    String encoded = new String(Base64.encodeBase64((byte[])(this.login + ":" + this.password).getBytes()));
                    connection.setRequestProperty("Authorization", "Basic " + encoded);
                }
                connection.setConnectTimeout(20000);
                connection.setReadTimeout(20000);
                connection.setUseCaches(true);
                connection.setInstanceFollowRedirects(true);
                connection.setRequestProperty("User-Agent", this.userAgent);
                int responseCode = connection.getResponseCode();
                if (responseCode >= 400) {
                    throw new HttpException(this.uri, responseCode);
                }
                return connection.getInputStream();
            }
        }
    }
}

