/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue.condition;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.condition.Condition;

@Beta
public final class HasIssuePropertyCondition
implements Condition {
    private final String propertyKey;

    public HasIssuePropertyCondition(String propertyKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)propertyKey) ? 1 : 0) != 0);
        this.propertyKey = propertyKey;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Override
    public boolean matches(Issue issue) {
        return !Strings.isNullOrEmpty((String)issue.attributes().get(this.propertyKey));
    }
}

