/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.SortedBag;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.bag.TransformedSortedBag;
import org.apache.commons.collections.bag.TreeBag;
import org.apache.commons.lang.NumberUtils;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureBuilder;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeDistributionBuilder
implements MeasureBuilder {
    private Metric metric;
    private SortedBag countBag;
    private boolean isEmpty = true;
    private Number[] bottomLimits;
    private boolean isValid = true;

    public RangeDistributionBuilder(Metric metric, Number[] bottomLimits) {
        this.setMetric(metric);
        this.init(bottomLimits);
    }

    private void init(Number[] bottomLimits) {
        this.bottomLimits = new Number[bottomLimits.length];
        System.arraycopy(bottomLimits, 0, this.bottomLimits, 0, this.bottomLimits.length);
        Arrays.sort(this.bottomLimits);
        this.changeDoublesToInts();
        this.countBag = TransformedSortedBag.decorate((SortedBag)new TreeBag(), (Transformer)new RangeTransformer());
        this.doClear();
    }

    private void changeDoublesToInts() {
        boolean onlyInts = true;
        for (Number bottomLimit : this.bottomLimits) {
            if (NumberUtils.compare((double)bottomLimit.intValue(), (double)bottomLimit.doubleValue()) == 0) continue;
            onlyInts = false;
        }
        if (onlyInts) {
            for (int i = 0; i < this.bottomLimits.length; ++i) {
                this.bottomLimits[i] = this.bottomLimits[i].intValue();
            }
        }
    }

    public RangeDistributionBuilder(Metric metric) {
        this.metric = metric;
    }

    public Number[] getBottomLimits() {
        return this.bottomLimits;
    }

    public RangeDistributionBuilder add(Number value) {
        return this.add(value, 1);
    }

    public RangeDistributionBuilder add(Number value, int count) {
        if (value != null && RangeDistributionBuilder.greaterOrEqualsThan(value, this.bottomLimits[0])) {
            this.countBag.add((Object)value, count);
            this.isEmpty = false;
        }
        return this;
    }

    private RangeDistributionBuilder addLimitCount(Number limit, int count) {
        for (Number bottomLimit : this.bottomLimits) {
            if (NumberUtils.compare((double)bottomLimit.doubleValue(), (double)limit.doubleValue()) != 0) continue;
            this.countBag.add((Object)limit, count);
            this.isEmpty = false;
            return this;
        }
        this.isValid = false;
        return this;
    }

    public RangeDistributionBuilder add(Measure measure) {
        if (measure != null && measure.getData() != null) {
            Map<Double, Double> map = KeyValueFormat.parse(measure.getData(), new KeyValueFormat.DoubleNumbersPairTransformer());
            Number[] limits = map.keySet().toArray(new Number[map.size()]);
            if (this.bottomLimits == null) {
                this.init(limits);
            } else if (!this.areSameLimits(this.bottomLimits, map.keySet())) {
                this.isValid = false;
            }
            if (this.isValid) {
                for (Map.Entry<Double, Double> entry : map.entrySet()) {
                    this.addLimitCount(entry.getKey(), entry.getValue().intValue());
                }
            }
        }
        return this;
    }

    private boolean areSameLimits(Number[] bottomLimits, Set<Double> limits) {
        if (limits.size() == bottomLimits.length) {
            for (Number l : bottomLimits) {
                if (limits.contains(l.doubleValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public RangeDistributionBuilder clear() {
        this.doClear();
        return this;
    }

    private void doClear() {
        if (this.countBag != null) {
            this.countBag.clear();
        }
        if (this.bottomLimits != null) {
            Collections.addAll(this.countBag, this.bottomLimits);
        }
        this.isEmpty = true;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public Measure build() {
        return this.build(true);
    }

    public Measure build(boolean allowEmptyData) {
        if (this.isValid && (!this.isEmpty || allowEmptyData)) {
            return new Measure(this.metric, KeyValueFormat.format((Bag)this.countBag, -1));
        }
        return null;
    }

    private static boolean greaterOrEqualsThan(Number n1, Number n2) {
        return NumberUtils.compare((double)n1.doubleValue(), (double)n2.doubleValue()) >= 0;
    }

    private void setMetric(Metric metric) {
        if (metric == null || !metric.isDataType()) {
            throw new SonarException("Metric is null or has unvalid type");
        }
        this.metric = metric;
    }

    private class RangeTransformer
    implements Transformer {
        private RangeTransformer() {
        }

        public Object transform(Object o) {
            Number n = (Number)o;
            for (int i = RangeDistributionBuilder.this.bottomLimits.length - 1; i >= 0; --i) {
                if (!RangeDistributionBuilder.greaterOrEqualsThan(n, RangeDistributionBuilder.this.bottomLimits[i])) continue;
                return RangeDistributionBuilder.this.bottomLimits[i];
            }
            return null;
        }
    }
}

