/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.ProxyAuthenticator;
import org.sonar.api.utils.SonarException;

public class HttpDownloader
implements BatchComponent,
ServerComponent {
    public static final int TIMEOUT_MILLISECONDS = 20000;
    private String userAgent;

    public HttpDownloader(Server server, Configuration configuration) {
        this(configuration, server.getVersion());
    }

    public HttpDownloader(Configuration configuration) {
        this(configuration, null);
    }

    public HttpDownloader() {
        this((Configuration)new PropertiesConfiguration(), null);
    }

    private HttpDownloader(Configuration configuration, String userAgent) {
        this.initProxy(configuration);
        this.initUserAgent(userAgent);
    }

    private void initProxy(Configuration configuration) {
        this.propagateProxySystemProperties(configuration);
        if (this.requiresProxyAuthentication(configuration)) {
            this.registerProxyCredentials(configuration);
        }
    }

    private void initUserAgent(String sonarVersion) {
        String userAgent = sonarVersion == null ? "Sonar" : String.format("Sonar %s", sonarVersion);
        System.setProperty("http.agent", userAgent);
        this.userAgent = userAgent;
    }

    public String getProxySynthesis(URI uri) {
        return HttpDownloader.getProxySynthesis(uri, ProxySelector.getDefault());
    }

    static String getProxySynthesis(URI uri, ProxySelector proxySelector) {
        ArrayList descriptions = Lists.newArrayList();
        List<Proxy> proxies = proxySelector.select(uri);
        if (proxies.size() == 1 && proxies.get(0).type().equals((Object)Proxy.Type.DIRECT)) {
            descriptions.add("no proxy");
        } else {
            for (Proxy proxy : proxies) {
                if (proxy.type().equals((Object)Proxy.Type.DIRECT)) continue;
                descriptions.add("proxy: " + proxy.address().toString());
            }
        }
        return Joiner.on((String)", ").join((Iterable)descriptions);
    }

    private void registerProxyCredentials(Configuration configuration) {
        Authenticator.setDefault(new ProxyAuthenticator(configuration.getString("http.proxyUser"), configuration.getString("http.proxyPassword")));
    }

    private boolean requiresProxyAuthentication(Configuration configuration) {
        return configuration.getString("http.proxyUser") != null;
    }

    private void propagateProxySystemProperties(Configuration configuration) {
        this.propagateSystemProperty(configuration, "http.proxyHost");
        this.propagateSystemProperty(configuration, "http.proxyPort");
        this.propagateSystemProperty(configuration, "http.nonProxyHosts");
        this.propagateSystemProperty(configuration, "http.auth.ntlm.domain");
        this.propagateSystemProperty(configuration, "socksProxyHost");
        this.propagateSystemProperty(configuration, "socksProxyPort");
    }

    private void propagateSystemProperty(Configuration configuration, String key) {
        if (configuration.getString(key) != null) {
            System.setProperty(key, configuration.getString(key));
        }
    }

    public void download(URI uri, File toFile) {
        InputStream input = null;
        FileOutputStream output = null;
        try {
            HttpURLConnection connection = this.newHttpConnection(uri);
            output = new FileOutputStream(toFile, false);
            input = connection.getInputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (Exception e) {
            try {
                IOUtils.closeQuietly(output);
                FileUtils.deleteQuietly((File)toFile);
                throw new SonarException("Fail to download the file: " + uri + " (" + this.getProxySynthesis(uri) + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
    }

    public byte[] download(URI uri) {
        byte[] byArray;
        InputStream input = null;
        try {
            HttpURLConnection connection = this.newHttpConnection(uri);
            input = connection.getInputStream();
            byArray = IOUtils.toByteArray((InputStream)input);
        }
        catch (Exception e) {
            try {
                throw new SonarException("Fail to download the file: " + uri + " (" + this.getProxySynthesis(uri) + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return byArray;
    }

    public String downloadPlainText(URI uri, String encoding) {
        String string;
        InputStream input = null;
        try {
            HttpURLConnection connection = this.newHttpConnection(uri);
            input = connection.getInputStream();
            string = IOUtils.toString((InputStream)input, (String)encoding);
        }
        catch (Exception e) {
            try {
                throw new SonarException("Fail to download the file: " + uri + " (" + this.getProxySynthesis(uri) + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return string;
    }

    public InputStream openStream(URI uri) {
        try {
            HttpURLConnection connection = this.newHttpConnection(uri);
            return connection.getInputStream();
        }
        catch (Exception e) {
            throw new SonarException("Fail to download the file: " + uri + " (" + this.getProxySynthesis(uri) + ")", e);
        }
    }

    private HttpURLConnection newHttpConnection(URI uri) throws IOException {
        LoggerFactory.getLogger(this.getClass()).debug("Download: " + uri + " (" + this.getProxySynthesis(uri) + ")");
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setConnectTimeout(20000);
        connection.setReadTimeout(20000);
        connection.setUseCaches(true);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("User-Agent", this.userAgent);
        return connection;
    }
}

