/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.maven.project.MavenProject;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends Resource {
    public static final String SCOPE = "PRJ";
    @Deprecated
    public static final String PARAM_VERSION = "sonar.projectVersion";
    @Deprecated
    public static final String PARAM_DATE = "sonar.projectDate";
    @Deprecated
    public static final String PARAM_LANGUAGE = "sonar.language";
    @Deprecated
    public static final String PARAM_DYNAMIC_ANALYSIS = "sonar.dynamicAnalysis";
    @Deprecated
    public static final String PARAM_EXCLUSIONS = "sonar.exclusions";
    @Deprecated
    public static final String PARAM_REUSE_RULES_CONFIG = "sonar.reuseExistingRulesConfiguration";
    private MavenProject pom;
    private String branch;
    private ProjectFileSystem fileSystem;
    private Configuration configuration;
    private String name;
    private String description;
    private String packaging;
    private Language language;
    private String languageKey;
    private Date analysisDate;
    private AnalysisType analysisType;
    private String[] exclusionPatterns;
    private String analysisVersion;
    private boolean latestAnalysis;
    private Project parent;
    private List<Project> modules = new ArrayList<Project>();

    public Project(String key) {
        this.setKey(key);
        this.setEffectiveKey(key);
    }

    public Project(String key, String branch, String name) {
        if (StringUtils.isNotBlank((String)branch)) {
            this.setKey(String.format("%s:%s", key, branch));
            this.name = String.format("%s %s", name, branch);
        } else {
            this.setKey(key);
            this.name = name;
        }
        this.setEffectiveKey(this.getKey());
        this.branch = branch;
    }

    public String getBranch() {
        return this.branch;
    }

    public Project setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public final Project setPom(MavenProject pom) {
        this.pom = pom;
        return this;
    }

    @Deprecated
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLongName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Project setName(String name) {
        this.name = name;
        return this;
    }

    public Project setDescription(String description) {
        this.description = description;
        return this;
    }

    @Deprecated
    public Project setPackaging(String packaging) {
        this.packaging = packaging;
        return this;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Project getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public boolean isModule() {
        return !this.isRoot();
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public Project setAnalysisType(AnalysisType at) {
        this.analysisType = at;
        return this;
    }

    public boolean isLatestAnalysis() {
        return this.latestAnalysis;
    }

    public Project setLatestAnalysis(boolean b) {
        this.latestAnalysis = b;
        return this;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    public Project setLanguage(Language language) {
        this.language = language;
        return this;
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public Project setLanguageKey(String languageKey) {
        this.languageKey = languageKey;
        return this;
    }

    public Project setAnalysisDate(Date analysisDate) {
        this.analysisDate = analysisDate;
        return this;
    }

    public Project setAnalysisVersion(String analysisVersion) {
        this.analysisVersion = analysisVersion;
        return this;
    }

    @Override
    public String getScope() {
        return SCOPE;
    }

    @Override
    public String getQualifier() {
        return this.isRoot() ? "TRK" : "BRC";
    }

    @Override
    public boolean matchFilePattern(String antPattern) {
        return false;
    }

    public Project getParent() {
        return this.parent;
    }

    public Project setParent(Project parent) {
        this.parent = parent;
        if (parent != null) {
            parent.modules.add(this);
        }
        return this;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.modules.remove(this);
        }
    }

    public List<Project> getModules() {
        return this.modules;
    }

    @Deprecated
    public boolean getReuseExistingRulesConfig() {
        return this.configuration != null && this.configuration.getBoolean(PARAM_REUSE_RULES_CONFIG, false);
    }

    public String getAnalysisVersion() {
        return this.analysisVersion;
    }

    public Date getAnalysisDate() {
        return this.analysisDate;
    }

    public String[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public Project setExclusionPatterns(String[] s) {
        this.exclusionPatterns = s;
        return this;
    }

    public ProjectFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Deprecated
    public Project setFileSystem(ProjectFileSystem fs) {
        this.fileSystem = fs;
        return this;
    }

    @Deprecated
    public String getGroupId() {
        return this.pom.getGroupId();
    }

    @Deprecated
    public String getArtifactId() {
        return this.pom.getArtifactId();
    }

    @Deprecated
    public MavenProject getPom() {
        return this.pom;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public final Project setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Object getProperty(String key) {
        return this.configuration != null ? this.configuration.getProperty(key) : null;
    }

    public static Project createFromMavenIds(String groupId, String artifactId) {
        return new Project(String.format("%s:%s", groupId, artifactId));
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("key", (Object)this.getKey()).append("qualifier", (Object)this.getQualifier()).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnalysisType {
        STATIC,
        DYNAMIC,
        REUSE_REPORTS;


        public boolean isDynamic(boolean includeReuseReportMode) {
            return this.equals((Object)DYNAMIC) || this.equals((Object)REUSE_REPORTS) && includeReuseReportMode;
        }
    }
}

