/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Formula;
import org.sonar.api.measures.FormulaContext;
import org.sonar.api.measures.FormulaData;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AverageComplexityFormula
implements Formula {
    private Metric byMetric;

    public AverageComplexityFormula(Metric byMetric) {
        this.byMetric = byMetric;
    }

    @Override
    public List<Metric> dependsUponMetrics() {
        return Arrays.asList(CoreMetrics.COMPLEXITY, this.byMetric);
    }

    @Override
    public Measure calculate(FormulaData data, FormulaContext context) {
        if (!this.shouldDecorateResource(data, context)) {
            return null;
        }
        if (ResourceUtils.isFile(context.getResource())) {
            Double byMeasure = MeasureUtils.getValue(data.getMeasure(this.byMetric), null);
            Double complexity = MeasureUtils.getValue(data.getMeasure(CoreMetrics.COMPLEXITY), null);
            if (complexity != null && byMeasure != null && byMeasure > 0.0) {
                return new Measure(context.getTargetMetric(), complexity / byMeasure);
            }
        } else {
            double totalByMeasure = 0.0;
            double totalComplexity = 0.0;
            boolean hasApplicableChildren = false;
            for (FormulaData childrenData : data.getChildren()) {
                Double childrenByMeasure = MeasureUtils.getValue(childrenData.getMeasure(this.byMetric), null);
                Double childrenComplexity = MeasureUtils.getValue(childrenData.getMeasure(CoreMetrics.COMPLEXITY), null);
                if (childrenComplexity == null || childrenByMeasure == null || !(childrenByMeasure > 0.0)) continue;
                totalByMeasure += childrenByMeasure.doubleValue();
                totalComplexity += childrenComplexity.doubleValue();
                hasApplicableChildren = true;
            }
            if (hasApplicableChildren) {
                return new Measure(context.getTargetMetric(), totalComplexity / totalByMeasure);
            }
        }
        return null;
    }

    private boolean shouldDecorateResource(FormulaData data, FormulaContext context) {
        return !MeasureUtils.hasValue(data.getMeasure(context.getTargetMetric()));
    }
}

