/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.design;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@Entity
@Table(name="dependencies")
public class DependencyDto {
    @Id
    @Column(name="id")
    @GeneratedValue
    private Long id;
    @Column(name="from_snapshot_id", updatable=true, nullable=false)
    private Integer fromSnapshotId;
    @Column(name="from_resource_id", updatable=true, nullable=false)
    private Integer fromResourceId;
    @Column(name="from_scope", updatable=true, nullable=true)
    private String fromScope;
    @Column(name="to_snapshot_id", updatable=true, nullable=false)
    private Integer toSnapshotId;
    @Column(name="to_resource_id", updatable=true, nullable=false)
    private Integer toResourceId;
    @Column(name="to_scope", updatable=true, nullable=true)
    private String toScope;
    @Column(name="dep_weight", updatable=true, nullable=true)
    private Integer weight;
    @Column(name="dep_usage", updatable=true, nullable=true, length=30)
    private String usage;
    @Column(name="project_snapshot_id", updatable=true, nullable=false)
    private Integer projectSnapshotId;
    @Column(name="parent_dependency_id", updatable=true, nullable=true)
    private Long parentDependencyId;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getFromSnapshotId() {
        return this.fromSnapshotId;
    }

    public DependencyDto setFromSnapshotId(Integer fromSnapshotId) {
        this.fromSnapshotId = fromSnapshotId;
        return this;
    }

    public Integer getFromResourceId() {
        return this.fromResourceId;
    }

    public DependencyDto setFromResourceId(Integer fromResourceId) {
        this.fromResourceId = fromResourceId;
        return this;
    }

    public Integer getToSnapshotId() {
        return this.toSnapshotId;
    }

    public DependencyDto setToSnapshotId(Integer toSnapshotId) {
        this.toSnapshotId = toSnapshotId;
        return this;
    }

    public Integer getToResourceId() {
        return this.toResourceId;
    }

    public DependencyDto setToResourceId(Integer toResourceId) {
        this.toResourceId = toResourceId;
        return this;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public DependencyDto setWeight(Integer weight) {
        if (weight < 0) {
            throw new IllegalArgumentException("Dependency weight can not be negative");
        }
        this.weight = weight;
        return this;
    }

    public String getFromScope() {
        return this.fromScope;
    }

    public DependencyDto setFromScope(String fromScope) {
        this.fromScope = fromScope;
        return this;
    }

    public String getToScope() {
        return this.toScope;
    }

    public DependencyDto setToScope(String toScope) {
        this.toScope = toScope;
        return this;
    }

    public String getUsage() {
        return this.usage;
    }

    public DependencyDto setUsage(String usage) {
        this.usage = usage;
        return this;
    }

    public Integer getProjectSnapshotId() {
        return this.projectSnapshotId;
    }

    public DependencyDto setProjectSnapshotId(Integer projectSnapshotId) {
        this.projectSnapshotId = projectSnapshotId;
        return this;
    }

    public Long getParentDependencyId() {
        return this.parentDependencyId;
    }

    public DependencyDto setParentDependencyId(Long parentDependencyId) {
        this.parentDependencyId = parentDependencyId;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DependencyDto)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DependencyDto other = (DependencyDto)obj;
        return new EqualsBuilder().append((Object)this.fromSnapshotId, (Object)other.fromSnapshotId).append((Object)this.toSnapshotId, (Object)other.toSnapshotId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.fromSnapshotId).append((Object)this.toSnapshotId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("fromSnapshotId", (Object)this.fromSnapshotId).append("fromResourceId", (Object)this.fromResourceId).append("fromScope", (Object)this.fromScope).append("toSnapshotId", (Object)this.toSnapshotId).append("toResourceId", (Object)this.toResourceId).append("toScope", (Object)this.toScope).append("weight", (Object)this.weight).append("usage", (Object)this.usage).append("projectSnapshotId", (Object)this.projectSnapshotId).append("parentDependencyId", (Object)this.parentDependencyId).toString();
    }
}

