/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.internal.pmd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.internal.pmd.TokensLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdBlockChunker {
    private static final long PRIME_BASE = 31L;
    private final int blockSize;
    private final long power;

    public PmdBlockChunker(int blockSize) {
        this.blockSize = blockSize;
        long pow = 1L;
        for (int i = 0; i < blockSize - 1; ++i) {
            pow *= 31L;
        }
        this.power = pow;
    }

    public List<Block> chunk(String resourceId, List<TokensLine> fragments) {
        int last;
        if (fragments.size() < this.blockSize) {
            return Collections.emptyList();
        }
        TokensLine[] fragmentsArr = fragments.toArray(new TokensLine[fragments.size()]);
        ArrayList blocks = Lists.newArrayListWithCapacity((int)(fragmentsArr.length - this.blockSize + 1));
        long hash = 0L;
        int first = 0;
        for (last = 0; last < this.blockSize - 1; ++last) {
            hash = hash * 31L + (long)fragmentsArr[last].getHashCode();
        }
        Block.Builder blockBuilder = Block.builder().setResourceId(resourceId);
        while (last < fragmentsArr.length) {
            TokensLine firstFragment = fragmentsArr[first];
            TokensLine lastFragment = fragmentsArr[last];
            hash = hash * 31L + (long)lastFragment.getHashCode();
            Block block = blockBuilder.setBlockHash(new ByteArray(hash)).setIndexInFile(first).setLines(firstFragment.getStartLine(), lastFragment.getEndLine()).setUnit(firstFragment.getStartUnit(), lastFragment.getEndUnit()).build();
            blocks.add(block);
            hash -= this.power * (long)firstFragment.getHashCode();
            ++last;
            ++first;
        }
        return blocks;
    }
}

