/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.checks.templates;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.checks.templates.BundleCheckTemplate;
import org.sonar.api.checks.templates.BundleCheckTemplateProperty;
import org.sonar.api.checks.templates.CheckTemplate;
import org.sonar.check.AnnotationIntrospector;
import org.sonar.check.Check;
import org.sonar.check.CheckProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AnnotationCheckTemplateFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationCheckTemplateFactory.class);
    private Collection<Class> annotatedClasses;

    public AnnotationCheckTemplateFactory(Collection<Class> annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public List<CheckTemplate> create() {
        ArrayList<CheckTemplate> templates = new ArrayList<CheckTemplate>();
        for (Class annotatedClass : this.annotatedClasses) {
            BundleCheckTemplate template = this.create(annotatedClass);
            if (template == null) continue;
            templates.add(template);
        }
        return templates;
    }

    protected BundleCheckTemplate create(Class annotatedClass) {
        Check checkAnnotation = AnnotationIntrospector.getCheckAnnotation((Class)annotatedClass);
        if (checkAnnotation == null) {
            LOG.warn("The class " + annotatedClass.getCanonicalName() + " is not a check template. It should be annotated with " + CheckTemplate.class);
            return null;
        }
        BundleCheckTemplate check = AnnotationCheckTemplateFactory.toTemplate(annotatedClass, checkAnnotation);
        Field[] fields = annotatedClass.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                BundleCheckTemplateProperty property = AnnotationCheckTemplateFactory.toProperty(check, field);
                if (property == null) continue;
                check.addProperty(property);
            }
        }
        return check;
    }

    private static BundleCheckTemplate toTemplate(Class annotatedClass, Check checkAnnotation) {
        String key = AnnotationIntrospector.getCheckKey((Class)annotatedClass);
        String bundle = AnnotationCheckTemplateFactory.getBundleBaseName(checkAnnotation, annotatedClass);
        BundleCheckTemplate check = new BundleCheckTemplate(key, bundle);
        check.setDefaultDescription(checkAnnotation.description());
        check.setDefaultTitle(checkAnnotation.title());
        check.setIsoCategory(checkAnnotation.isoCategory());
        check.setPriority(checkAnnotation.priority());
        return check;
    }

    private static String getBundleBaseName(Check checkAnnotation, Class annotatedClass) {
        String bundle = checkAnnotation.bundle();
        if (StringUtils.isBlank((String)bundle)) {
            bundle = annotatedClass.getCanonicalName();
        }
        return bundle;
    }

    private static BundleCheckTemplateProperty toProperty(BundleCheckTemplate check, Field field) {
        CheckProperty propertyAnnotation = field.getAnnotation(CheckProperty.class);
        if (propertyAnnotation != null) {
            String fieldKey = propertyAnnotation.key();
            if (fieldKey == null || "".equals(fieldKey)) {
                fieldKey = field.getName();
            }
            BundleCheckTemplateProperty property = new BundleCheckTemplateProperty(check, fieldKey);
            property.setDefaultTitle(propertyAnnotation.title());
            property.setDefaultDescription(propertyAnnotation.description());
            return property;
        }
        return null;
    }
}

