/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.source;

import org.sonar.api.component.Component;
import org.sonar.api.source.Highlightable;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.source.SyntaxHighlightingDataBuilder;
import org.sonar.core.source.SnapshotDataType;

public class DefaultHighlightable
implements Highlightable {
    private final Component component;
    private final ComponentDataCache cache;
    private final SyntaxHighlightingDataBuilder builder;

    public DefaultHighlightable(Component component, ComponentDataCache cache) {
        this.component = component;
        this.cache = cache;
        this.builder = new SyntaxHighlightingDataBuilder();
    }

    public Highlightable.HighlightingBuilder newHighlighting() {
        return new DefaultHighlightingBuilder();
    }

    public Component component() {
        return this.component;
    }

    public SyntaxHighlightingDataBuilder getHighlightingRules() {
        return this.builder;
    }

    private class DefaultHighlightingBuilder
    implements Highlightable.HighlightingBuilder {
        private DefaultHighlightingBuilder() {
        }

        public Highlightable.HighlightingBuilder highlight(int startOffset, int endOffset, String typeOfText) {
            DefaultHighlightable.this.builder.registerHighlightingRule(startOffset, endOffset, typeOfText);
            return this;
        }

        public void done() {
            DefaultHighlightable.this.cache.setStringData(DefaultHighlightable.this.component().key(), SnapshotDataType.SYNTAX_HIGHLIGHTING.getValue(), DefaultHighlightable.this.builder.build().writeString());
        }
    }
}

