/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.maven.MavenUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;

public class MavenProjectConverter {
    private static final String UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE = "Unable to determine structure of project. Probably you use Maven Advanced Reactor Options, which is not supported by Sonar and should not be used.";

    private MavenProjectConverter() {
    }

    public static ProjectDefinition convert(List<MavenProject> poms, MavenProject root) {
        HashMap paths = Maps.newHashMap();
        HashMap defs = Maps.newHashMap();
        try {
            for (MavenProject mavenProject : poms) {
                paths.put(mavenProject.getFile().getCanonicalPath(), mavenProject);
                defs.put(mavenProject, MavenProjectConverter.convert(mavenProject));
            }
            for (Map.Entry entry : paths.entrySet()) {
                MavenProject pom = (MavenProject)entry.getValue();
                for (Object m : pom.getModules()) {
                    String moduleId = (String)m;
                    File modulePath = new File(pom.getBasedir(), moduleId);
                    MavenProject module = MavenProjectConverter.findMavenProject(modulePath, paths);
                    ProjectDefinition parentProject = (ProjectDefinition)defs.get(pom);
                    if (parentProject == null) {
                        throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
                    }
                    ProjectDefinition subProject = (ProjectDefinition)defs.get(module);
                    if (subProject == null) {
                        throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
                    }
                    parentProject.addSubProject(subProject);
                }
            }
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        ProjectDefinition rootProject = (ProjectDefinition)defs.get(root);
        if (rootProject == null) {
            throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
        }
        return rootProject;
    }

    private static MavenProject findMavenProject(File modulePath, Map<String, MavenProject> paths) throws IOException {
        if (modulePath.exists() && modulePath.isDirectory()) {
            for (Map.Entry<String, MavenProject> entry : paths.entrySet()) {
                String pomFileParentDir = new File(entry.getKey()).getParent();
                if (!pomFileParentDir.equals(modulePath.getCanonicalPath())) continue;
                return entry.getValue();
            }
            return null;
        }
        return paths.get(modulePath.getCanonicalPath());
    }

    @VisibleForTesting
    static ProjectDefinition convert(MavenProject pom) {
        String key = pom.getGroupId() + ":" + pom.getArtifactId();
        ProjectDefinition definition = ProjectDefinition.create();
        definition.setProperties(pom.getModel().getProperties()).setKey(key).setVersion(pom.getVersion()).setName(pom.getName()).setDescription(pom.getDescription()).addContainerExtension((Object)pom);
        MavenProjectConverter.guessJavaVersion(pom, definition);
        MavenProjectConverter.guessEncoding(pom, definition);
        MavenProjectConverter.convertMavenLinksToProperties(definition, pom);
        MavenProjectConverter.synchronizeFileSystem(pom, definition);
        return definition;
    }

    private static void guessEncoding(MavenProject pom, ProjectDefinition definition) {
        String encoding = MavenUtils.getSourceEncoding((MavenProject)pom);
        if (encoding != null) {
            definition.setProperty("sonar.sourceEncoding", encoding);
        }
    }

    private static void guessJavaVersion(MavenProject pom, ProjectDefinition definition) {
        String version = MavenUtils.getJavaSourceVersion((MavenProject)pom);
        if (version != null) {
            definition.setProperty("sonar.java.source", version);
        }
        if ((version = MavenUtils.getJavaVersion((MavenProject)pom)) != null) {
            definition.setProperty("sonar.java.target", version);
        }
    }

    private static void convertMavenLinksToProperties(ProjectDefinition definition, MavenProject pom) {
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.homepage", pom.getUrl());
        Scm scm = pom.getScm();
        if (scm == null) {
            scm = new Scm();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.scm", scm.getUrl());
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.scm_dev", scm.getDeveloperConnection());
        CiManagement ci = pom.getCiManagement();
        if (ci == null) {
            ci = new CiManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.ci", ci.getUrl());
        IssueManagement issues = pom.getIssueManagement();
        if (issues == null) {
            issues = new IssueManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.issue", issues.getUrl());
    }

    private static void setPropertyIfNotAlreadyExists(ProjectDefinition definition, String propertyKey, String propertyValue) {
        if (StringUtils.isBlank((String)definition.getProperties().getProperty(propertyKey))) {
            definition.setProperty(propertyKey, StringUtils.defaultString((String)propertyValue));
        }
    }

    public static void synchronizeFileSystem(MavenProject pom, ProjectDefinition into) {
        into.setBaseDir(pom.getBasedir());
        File buildDir = MavenProjectConverter.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir());
        if (buildDir != null) {
            into.setBuildDir(buildDir);
            into.setWorkDir(new File(buildDir, "sonar"));
        }
        into.setSourceDirs(pom.getCompileSourceRoots().toArray(new String[pom.getCompileSourceRoots().size()]));
        into.setTestDirs(pom.getTestCompileSourceRoots().toArray(new String[pom.getTestCompileSourceRoots().size()]));
        File binaryDir = MavenProjectConverter.resolvePath(pom.getBuild().getOutputDirectory(), pom.getBasedir());
        if (binaryDir != null) {
            into.addBinaryDir(binaryDir);
        }
    }

    public static void synchronizeFileSystem(MavenProject pom, DefaultModuleFileSystem into) {
        into.resetDirs(pom.getBasedir(), MavenProjectConverter.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir()), MavenProjectConverter.resolvePaths(pom.getCompileSourceRoots(), pom.getBasedir()), MavenProjectConverter.resolvePaths(pom.getTestCompileSourceRoots(), pom.getBasedir()), Arrays.asList(MavenProjectConverter.resolvePath(pom.getBuild().getOutputDirectory(), pom.getBasedir())));
    }

    static File resolvePath(String path, File basedir) {
        if (path != null) {
            File file = new File(path);
            if (!file.isAbsolute()) {
                try {
                    file = new File(basedir, path).getCanonicalFile();
                }
                catch (IOException e) {
                    throw new SonarException("Unable to resolve path '" + path + "'", (Throwable)e);
                }
            }
            return file;
        }
        return null;
    }

    static List<File> resolvePaths(List<String> paths, File basedir) {
        ArrayList result = Lists.newArrayList();
        for (String path : paths) {
            File dir = MavenProjectConverter.resolvePath(path, basedir);
            if (dir == null) continue;
            result.add(dir);
        }
        return result;
    }
}

