/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.FileSystemFilter;
import org.sonar.api.scan.filesystem.FileType;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.LanguageFilters;
import org.sonar.batch.scan.filesystem.WhiteListFileFilter;

public class ModuleFileSystemProvider
extends ProviderAdapter {
    private DefaultModuleFileSystem singleton;

    public DefaultModuleFileSystem provide(ProjectDefinition module, PathResolver pathResolver, TempDirectories tempDirectories, LanguageFilters languageFilters, Settings settings, FileSystemFilter[] pluginFileFilters) {
        if (this.singleton == null) {
            DefaultModuleFileSystem fs = new DefaultModuleFileSystem();
            fs.setLanguageFilters(languageFilters);
            fs.setBaseDir(module.getBaseDir());
            fs.setBuildDir(module.getBuildDir());
            fs.setSettings(settings);
            fs.setWorkingDir(this.guessWorkingDir(module, tempDirectories));
            fs.addFilters(pluginFileFilters);
            this.initBinaryDirs(module, pathResolver, fs);
            this.initSources(module, pathResolver, fs);
            this.initTests(module, pathResolver, fs);
            this.singleton = fs;
        }
        return this.singleton;
    }

    private File guessWorkingDir(ProjectDefinition module, TempDirectories tempDirectories) {
        File workDir = module.getWorkDir();
        if (workDir == null) {
            workDir = tempDirectories.getDir("work");
        } else {
            try {
                FileUtils.forceMkdir((File)workDir);
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to create working dir: " + workDir.getAbsolutePath(), e);
            }
        }
        return workDir;
    }

    private void initSources(ProjectDefinition module, PathResolver pathResolver, DefaultModuleFileSystem fs) {
        for (String sourcePath : module.getSourceDirs()) {
            File dir = pathResolver.relativeFile(module.getBaseDir(), sourcePath);
            if (!dir.isDirectory() || !dir.exists()) continue;
            fs.addSourceDir(dir);
        }
        List sourceFiles = pathResolver.relativeFiles(module.getBaseDir(), module.getSourceFiles());
        if (!sourceFiles.isEmpty()) {
            fs.addFilters(new WhiteListFileFilter(FileType.SOURCE, (Set<File>)ImmutableSet.copyOf((Collection)sourceFiles)));
        }
    }

    private void initTests(ProjectDefinition module, PathResolver pathResolver, DefaultModuleFileSystem fs) {
        for (String testPath : module.getTestDirs()) {
            File dir = pathResolver.relativeFile(module.getBaseDir(), testPath);
            if (!dir.exists() || !dir.isDirectory()) continue;
            fs.addTestDir(dir);
        }
        List testFiles = pathResolver.relativeFiles(module.getBaseDir(), module.getTestFiles());
        if (!testFiles.isEmpty()) {
            fs.addFilters(new WhiteListFileFilter(FileType.TEST, (Set<File>)ImmutableSet.copyOf((Collection)testFiles)));
        }
    }

    private void initBinaryDirs(ProjectDefinition module, PathResolver pathResolver, DefaultModuleFileSystem fs) {
        for (String path : module.getBinaries()) {
            File dir = pathResolver.relativeFile(module.getBaseDir(), path);
            fs.addBinaryDir(dir);
        }
    }
}

