/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.Semaphores;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.scan.DurationLabel;

public class ProjectLock {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectLock.class);
    private final Semaphores semaphores;
    private final ProjectTree projectTree;
    private final Settings settings;

    public ProjectLock(Semaphores semaphores, ProjectTree projectTree, Settings settings) {
        this.semaphores = semaphores;
        this.projectTree = projectTree;
        this.settings = settings;
    }

    public void start() {
        Semaphores.Semaphore semaphore;
        if (!this.isInDryRunMode() && StringUtils.isNotBlank((String)this.getProject().getKey()) && !(semaphore = this.acquire()).isLocked()) {
            LOG.error(this.getErrorMessage(semaphore));
            throw new SonarException("The project is already being analysed.");
        }
    }

    private String getErrorMessage(Semaphores.Semaphore semaphore) {
        long duration = semaphore.getDurationSinceLocked();
        DurationLabel durationLabel = new DurationLabel();
        String durationDisplay = durationLabel.label(duration);
        return "It looks like an analysis of '" + this.getProject().getName() + "' is already running (started " + durationDisplay + ").";
    }

    public void stop() {
        if (!this.isInDryRunMode()) {
            this.release();
        }
    }

    private Semaphores.Semaphore acquire() {
        LOG.debug("Acquire semaphore on project : {}, with key {}", (Object)this.getProject(), (Object)this.getSemaphoreKey());
        return this.semaphores.acquire(this.getSemaphoreKey(), 15, 10);
    }

    private void release() {
        LOG.debug("Release semaphore on project : {}, with key {}", (Object)this.getProject(), (Object)this.getSemaphoreKey());
        this.semaphores.release(this.getSemaphoreKey());
    }

    private String getSemaphoreKey() {
        return "batch-" + this.getProject().getKey();
    }

    private Project getProject() {
        return this.projectTree.getRootProject();
    }

    private boolean isInDryRunMode() {
        return this.settings.getBoolean("sonar.dryRun");
    }
}

