/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closeables;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.platform.Server;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.issue.IssueCache;
import org.sonar.core.i18n.RuleI18nManager;

@Deprecated
public class DeprecatedJsonReport
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(DeprecatedJsonReport.class);
    private final Settings settings;
    private final DefaultIndex sonarIndex;
    private final ModuleFileSystem fileSystem;
    private final Server server;
    private final RuleI18nManager ruleI18nManager;
    private final IssueCache issueCache;

    public DeprecatedJsonReport(Settings settings, DefaultIndex sonarIndex, ModuleFileSystem fileSystem, Server server, RuleI18nManager ruleI18nManager, IssueCache issueCache) {
        this.settings = settings;
        this.sonarIndex = sonarIndex;
        this.fileSystem = fileSystem;
        this.server = server;
        this.ruleI18nManager = ruleI18nManager;
        this.issueCache = issueCache;
    }

    public void execute() {
        if (this.settings.getBoolean("sonar.dryRun")) {
            this.exportResults(this.sonarIndex.getResources());
        }
    }

    private void exportResults(Collection<Resource> resources) {
        File exportFile = new File(this.fileSystem.workingDir(), this.settings.getString("sonar.dryRun.export.path"));
        LOG.info("Export (deprecated) dry run results to " + exportFile.getAbsolutePath());
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new FileWriter(exportFile));
            this.writeJson(resources, output);
        }
        catch (IOException e) {
            try {
                throw new SonarException("Unable to write DryRun results in file " + exportFile.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(output);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)output);
    }

    @VisibleForTesting
    void writeJson(Collection<Resource> resources, Writer writer) {
        JsonWriter json = null;
        try {
            json = new JsonWriter(writer);
            json.setSerializeNulls(false);
            json.beginObject().name("version").value(this.server.getVersion()).name("violations_per_resource").beginObject();
            for (Resource resource : resources) {
                Iterable<DefaultIssue> issues = this.getIssues(resource);
                boolean hasViolation = false;
                for (DefaultIssue issue : issues) {
                    if (!hasViolation) {
                        json.name(resource.getKey()).beginArray();
                        hasViolation = true;
                    }
                    json.beginObject().name("line").value((Number)issue.line()).name("message").value(issue.message()).name("severity").value(issue.severity()).name("rule_key").value(issue.ruleKey().rule()).name("rule_repository").value(issue.ruleKey().repository()).name("rule_name").value(this.ruleName(issue.ruleKey())).name("switched_off").value("FALSE-POSITIVE".equals(issue.resolution())).name("is_new").value(issue.isNew()).name("created_at").value(DateUtils.formatDateTime((Date)issue.creationDate())).endObject();
                }
                if (!hasViolation) continue;
                json.endArray();
            }
            json.endObject().endObject().flush();
        }
        catch (IOException e) {
            try {
                throw new SonarException("Unable to export results", (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(json);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)json);
    }

    private String ruleName(RuleKey key) {
        return this.ruleI18nManager.getName(key.repository(), key.rule(), Locale.getDefault());
    }

    @VisibleForTesting
    Iterable<DefaultIssue> getIssues(Resource resource) {
        return this.issueCache.byComponent(resource.getEffectiveKey());
    }
}

