/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.sonar.api.component.Perspective;
import org.sonar.batch.index.ScanPersister;
import org.sonar.core.component.ComponentVertex;
import org.sonar.core.component.GraphPerspectiveBuilder;
import org.sonar.core.component.ScanGraph;
import org.sonar.core.graph.EdgePath;
import org.sonar.core.graph.SubGraph;
import org.sonar.core.graph.graphson.GraphsonMode;
import org.sonar.core.graph.graphson.GraphsonWriter;
import org.sonar.core.graph.jdbc.GraphDto;
import org.sonar.core.graph.jdbc.GraphDtoMapper;
import org.sonar.core.persistence.BatchSession;
import org.sonar.core.persistence.MyBatis;

public class GraphPersister
implements ScanPersister {
    private final MyBatis myBatis;
    private final ScanGraph projectGraph;
    private final GraphPerspectiveBuilder[] builders;

    public GraphPersister(MyBatis myBatis, ScanGraph projectGraph, GraphPerspectiveBuilder[] builders) {
        this.myBatis = myBatis;
        this.projectGraph = projectGraph;
        this.builders = builders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist() {
        BatchSession session = this.myBatis.openBatchSession();
        GraphDtoMapper mapper = (GraphDtoMapper)session.getMapper(GraphDtoMapper.class);
        try {
            for (ComponentVertex component : this.projectGraph.getComponents()) {
                this.persistComponentGraph(mapper, component);
            }
            session.commit();
        }
        finally {
            session.close();
        }
    }

    private void persistComponentGraph(GraphDtoMapper mapper, ComponentVertex component) {
        Long snapshotId = (Long)((Vertex)component.element()).getProperty("sid");
        if (snapshotId != null) {
            for (GraphPerspectiveBuilder builder : this.builders) {
                GraphPerspectiveBuilder graphPerspectiveBuilder = builder;
                Perspective perspective = graphPerspectiveBuilder.getPerspectiveLoader().load(component);
                if (perspective == null) continue;
                this.serializePerspectiveData(mapper, component, snapshotId, graphPerspectiveBuilder);
            }
        }
    }

    private void serializePerspectiveData(GraphDtoMapper mapper, ComponentVertex component, Long snapshotId, GraphPerspectiveBuilder builder) {
        Graph subGraph = SubGraph.extract((Vertex)((Vertex)component.element()), (EdgePath)builder.path());
        String data = this.write(subGraph);
        mapper.insert(new GraphDto().setData(data).setFormat("graphson").setPerspective(builder.getPerspectiveLoader().getPerspectiveKey()).setVersion(1).setResourceId(((Long)((Vertex)component.element()).getProperty("rid")).longValue()).setSnapshotId(snapshotId.longValue()).setRootVertexId(((Vertex)component.element()).getId().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String write(Graph graph) {
        StringWriter output = new StringWriter();
        try {
            new GraphsonWriter().write(graph, (Writer)output, GraphsonMode.EXTENDED);
            String string = output.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((Writer)output);
        }
    }
}

