/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.Event;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Resource;
import org.sonar.batch.index.ResourcePersister;

public final class EventPersister {
    private DatabaseSession session;
    private ResourcePersister resourcePersister;

    public EventPersister(DatabaseSession session, ResourcePersister resourcePersister) {
        this.session = session;
        this.resourcePersister = resourcePersister;
    }

    public List<Event> getEvents(Resource resource) {
        Snapshot snapshot = this.resourcePersister.getSnapshot(resource);
        if (snapshot == null) {
            return Collections.emptyList();
        }
        return this.session.getResults(Event.class, new Object[]{"resourceId", snapshot.getResourceId()});
    }

    public void deleteEvent(Event event) {
        this.session.removeWithoutFlush((Object)event);
        this.session.commit();
    }

    public void saveEvent(Resource resource, Event event) {
        Snapshot snapshot = this.resourcePersister.getSnapshotOrFail(resource);
        if (event.getDate() == null) {
            event.setSnapshot(snapshot);
        } else {
            event.setResourceId(snapshot.getResourceId());
        }
        this.session.save((Object)event);
        this.session.commit();
    }
}

