/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.BootstrapSettings;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

public class ServerClient
implements BatchComponent {
    private BootstrapSettings settings;
    private HttpDownloader.BaseHttpDownloader downloader;

    public ServerClient(BootstrapSettings settings, EnvironmentInformation env) {
        this.settings = settings;
        this.downloader = new HttpDownloader.BaseHttpDownloader(settings.properties(), env.toString());
    }

    public String getURL() {
        return StringUtils.removeEnd((String)this.settings.property("sonar.host.url", "http://localhost:9000"), (String)"/");
    }

    public void download(String pathStartingWithSlash, File toFile) {
        try {
            InputSupplier<InputStream> inputSupplier = this.doRequest(pathStartingWithSlash);
            Files.copy(inputSupplier, (File)toFile);
        }
        catch (HttpDownloader.HttpException he) {
            throw this.handleHttpException(he);
        }
        catch (IOException e) {
            throw new SonarException(String.format("Unable to download '%s' to: %s", pathStartingWithSlash, toFile), (Throwable)e);
        }
    }

    public String request(String pathStartingWithSlash) {
        return this.request(pathStartingWithSlash, true);
    }

    public String request(String pathStartingWithSlash, boolean wrapHttpException) {
        InputSupplier<InputStream> inputSupplier = this.doRequest(pathStartingWithSlash);
        try {
            return IOUtils.toString((InputStream)((InputStream)inputSupplier.getInput()), (String)"UTF-8");
        }
        catch (HttpDownloader.HttpException e) {
            throw wrapHttpException ? this.handleHttpException(e) : e;
        }
        catch (IOException e) {
            throw new SonarException(String.format("Unable to request: %s", pathStartingWithSlash), (Throwable)e);
        }
    }

    private InputSupplier<InputStream> doRequest(String pathStartingWithSlash) {
        Preconditions.checkArgument((boolean)pathStartingWithSlash.startsWith("/"), (Object)"Path must start with slash /");
        String path = StringEscapeUtils.escapeHtml((String)pathStartingWithSlash);
        URI uri = URI.create(this.getURL() + path);
        try {
            InputSupplier inputSupplier = Strings.isNullOrEmpty((String)this.getLogin()) ? this.downloader.newInputSupplier(uri) : this.downloader.newInputSupplier(uri, this.getLogin(), this.getPassword());
            return inputSupplier;
        }
        catch (Exception e) {
            throw new SonarException(String.format("Unable to request: %s", uri), (Throwable)e);
        }
    }

    private RuntimeException handleHttpException(HttpDownloader.HttpException he) {
        if (he.getResponseCode() == 401) {
            return new SonarException(String.format(this.getMessageWhenNotAuthorized(), "sonar.login", "sonar.password"));
        }
        return new SonarException(String.format("Fail to execute request [code=%s, url=%s]", he.getResponseCode(), he.getUri()), (Throwable)he);
    }

    private String getMessageWhenNotAuthorized() {
        if (Strings.isNullOrEmpty((String)this.getLogin()) && Strings.isNullOrEmpty((String)this.getPassword())) {
            return "Not authorized. Analyzing this project requires to be authenticated. Please provide the values of the properties %s and %s.";
        }
        return "Not authorized. Please check the properties %s and %s.";
    }

    private String getLogin() {
        return this.settings.property("sonar.login");
    }

    private String getPassword() {
        return this.settings.property("sonar.password");
    }
}

