/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.platform.PluginRepository;
import org.sonar.batch.bootstrap.PluginDownloader;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.core.plugins.DefaultPluginMetadata;
import org.sonar.core.plugins.PluginClassloaders;
import org.sonar.core.plugins.PluginInstaller;
import org.sonar.core.plugins.RemotePlugin;

public class BatchPluginRepository
implements PluginRepository {
    private static final Logger LOG = LoggerFactory.getLogger(BatchPluginRepository.class);
    private static final String CORE_PLUGIN = "core";
    private static final String ENGLISH_PACK_PLUGIN = "l10nen";
    private PluginDownloader pluginDownloader;
    private Map<String, Plugin> pluginsByKey;
    private Map<String, PluginMetadata> metadataByKey;
    private Settings settings;
    private PluginClassloaders classLoaders;
    private TempDirectories workingDirectories;

    public BatchPluginRepository(PluginDownloader pluginDownloader, TempDirectories workingDirectories, Settings settings) {
        this.pluginDownloader = pluginDownloader;
        this.workingDirectories = workingDirectories;
        this.settings = settings;
    }

    public void start() {
        LOG.info("Install plugins");
        this.doStart(this.pluginDownloader.downloadPluginIndex());
    }

    void doStart(List<RemotePlugin> remotePlugins) {
        PluginFilter filter = new PluginFilter(this.settings);
        PluginInstaller extractor = new PluginInstaller();
        this.metadataByKey = Maps.newHashMap();
        for (RemotePlugin remote : remotePlugins) {
            if (!filter.accepts(remote.getKey())) continue;
            List<File> pluginFiles = this.pluginDownloader.downloadPlugin(remote);
            List<File> extensionFiles = pluginFiles.subList(1, pluginFiles.size());
            File targetDir = this.workingDirectories.getDir("plugins/" + remote.getKey());
            LOG.debug("Installing plugin {} into {}", (Object)remote.getKey(), (Object)targetDir.getAbsolutePath());
            DefaultPluginMetadata metadata = extractor.install(pluginFiles.get(0), remote.isCore(), extensionFiles, targetDir);
            if (StringUtils.isBlank((String)metadata.getBasePlugin()) || filter.accepts(metadata.getBasePlugin())) {
                this.metadataByKey.put(metadata.getKey(), (PluginMetadata)metadata);
                continue;
            }
            LOG.debug("Excluded plugin: " + metadata.getKey());
        }
        this.classLoaders = new PluginClassloaders(Thread.currentThread().getContextClassLoader());
        this.pluginsByKey = this.classLoaders.init(this.metadataByKey.values());
    }

    public void stop() {
        if (this.classLoaders != null) {
            this.classLoaders.clean();
            this.classLoaders = null;
        }
    }

    public Plugin getPlugin(String key) {
        return this.pluginsByKey.get(key);
    }

    public Collection<PluginMetadata> getMetadata() {
        return this.metadataByKey.values();
    }

    public PluginMetadata getMetadata(String pluginKey) {
        return this.metadataByKey.get(pluginKey);
    }

    public Map<PluginMetadata, Plugin> getPluginsByMetadata() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, PluginMetadata> entry : this.metadataByKey.entrySet()) {
            String pluginKey = entry.getKey();
            PluginMetadata metadata = entry.getValue();
            result.put(metadata, this.pluginsByKey.get(pluginKey));
        }
        return result;
    }

    static class PluginFilter {
        Set<String> whites = Sets.newHashSet();
        Set<String> blacks = Sets.newHashSet();

        PluginFilter(Settings settings) {
            if (settings.hasKey("sonar.includePlugins")) {
                this.whites.addAll(Arrays.asList(settings.getStringArray("sonar.includePlugins")));
            }
            if (settings.hasKey("sonar.excludePlugins")) {
                this.blacks.addAll(Arrays.asList(settings.getStringArray("sonar.excludePlugins")));
            }
            if (settings.getBoolean("sonar.dryRun")) {
                this.whites.addAll(PluginFilter.propertyValues(settings, "sonar.dryRun.includePlugins", ""));
                this.blacks.addAll(PluginFilter.propertyValues(settings, "sonar.dryRun.excludePlugins", "devcockpit,pdfreport,report,scmactivity,views"));
            }
            if (!this.whites.isEmpty()) {
                LOG.info("Include plugins: " + Joiner.on((String)", ").join(this.whites));
            }
            if (!this.blacks.isEmpty()) {
                LOG.info("Exclude plugins: " + Joiner.on((String)", ").join(this.blacks));
            }
        }

        static List<String> propertyValues(Settings settings, String key, String defaultValue) {
            String s = StringUtils.defaultIfEmpty((String)settings.getString(key), (String)defaultValue);
            return Arrays.asList(StringUtils.split((String)s, (String)","));
        }

        boolean accepts(String pluginKey) {
            if (BatchPluginRepository.CORE_PLUGIN.equals(pluginKey) || BatchPluginRepository.ENGLISH_PACK_PLUGIN.equals(pluginKey)) {
                return true;
            }
            if (!this.whites.isEmpty()) {
                return this.whites.contains(pluginKey);
            }
            return this.blacks.isEmpty() || !this.blacks.contains(pluginKey);
        }
    }
}

