/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import javax.annotation.Nullable;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.task.TaskDefinition;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.Container;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrap.TaskContainer;
import org.sonar.batch.scan.ScanTask;
import org.sonar.batch.tasks.ListTasksTask;
import org.sonar.batch.tasks.Tasks;

public class TaskBootstrapContainer
extends Container {
    private String taskCommand;

    public TaskBootstrapContainer(@Nullable String taskCommand) {
        this.taskCommand = taskCommand;
    }

    protected void configure() {
        this.registerCoreTaskDefinitions();
        this.registerTaskDefinitionExtensions();
        this.container.addSingleton(Tasks.class);
    }

    private void registerCoreTaskDefinitions() {
        this.container.addSingleton((Object)ScanTask.DEFINITION);
        this.container.addSingleton((Object)ListTasksTask.DEFINITION);
    }

    private void registerTaskDefinitionExtensions() {
        ExtensionInstaller installer = (ExtensionInstaller)this.container.getComponentByType(ExtensionInstaller.class);
        installer.installTaskDefinitionExtensions(this.container);
    }

    protected void doStart() {
        Tasks tasks = (Tasks)this.container.getComponentByType(Tasks.class);
        this.executeTask(tasks.getTaskDefinition(this.taskCommand));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(TaskDefinition taskDefinition) {
        boolean projectPresent;
        boolean bl = projectPresent = this.container.getComponentByType(ProjectReactor.class) != null;
        if (ExtensionUtils.requiresProject(taskDefinition.getTask()) && !projectPresent) {
            throw new SonarException("Task '" + taskDefinition.getName() + "' requires to be run on a project");
        }
        TaskContainer childModule = new TaskContainer(taskDefinition, projectPresent);
        try {
            this.installChild(childModule);
            childModule.start();
        }
        finally {
            childModule.stop();
            this.uninstallChild();
        }
    }
}

