/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.sonar.api.BatchComponent;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;

public class LanguageFilters
implements BatchComponent {
    private final Languages languages;

    public LanguageFilters(Languages languages) {
        this.languages = languages;
    }

    public IOFileFilter forLang(String lang) {
        Language language = this.languages.get(lang);
        if (language == null) {
            return FalseFileFilter.FALSE;
        }
        String[] suffixes = language.getFileSuffixes();
        if (suffixes != null && suffixes.length > 0) {
            return new SuffixFileFilter(suffixes, IOCase.SENSITIVE);
        }
        return TrueFileFilter.TRUE;
    }
}

