/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.FileSystemFilter;
import org.sonar.api.scan.filesystem.FileType;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.batch.scan.filesystem.ExclusionFilter;
import org.sonar.batch.scan.filesystem.FileFilterContext;
import org.sonar.batch.scan.filesystem.FileFilterWrapper;
import org.sonar.batch.scan.filesystem.InclusionFilter;
import org.sonar.batch.scan.filesystem.LanguageFilters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleFileSystem
implements ModuleFileSystem {
    private static final IOFileFilter DIR_FILTER = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{HiddenFileFilter.VISIBLE, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"."))});
    private Settings settings;
    private File baseDir;
    private File workingDir;
    private File buildDir;
    private List<File> sourceDirs = Lists.newArrayList();
    private List<File> testDirs = Lists.newArrayList();
    private List<File> binaryDirs = Lists.newArrayList();
    private PathResolver pathResolver = new PathResolver();
    private List<FileSystemFilter> fsFilters = Lists.newArrayList();
    private LanguageFilters languageFilters;

    DefaultModuleFileSystem() {
    }

    public File baseDir() {
        return this.baseDir;
    }

    public File buildDir() {
        return this.buildDir;
    }

    public List<File> sourceDirs() {
        return this.sourceDirs;
    }

    public List<File> testDirs() {
        return this.testDirs;
    }

    public List<File> binaryDirs() {
        return this.binaryDirs;
    }

    public Charset sourceCharset() {
        String encoding = this.settings.getString("sonar.sourceEncoding");
        Charset charset = StringUtils.isNotEmpty((String)encoding) ? Charset.forName(StringUtils.trim((String)encoding)) : Charset.defaultCharset();
        return charset;
    }

    boolean isDefaultSourceCharset() {
        return !this.settings.hasKey("sonar.sourceEncoding");
    }

    public File workingDir() {
        return this.workingDir;
    }

    List<FileSystemFilter> filters() {
        return this.fsFilters;
    }

    LanguageFilters languageFilters() {
        return this.languageFilters;
    }

    public List<File> files(FileQuery query) {
        ArrayList filters = Lists.newArrayList(this.fsFilters);
        for (FileFilter fileFilter : query.filters()) {
            filters.add(new FileFilterWrapper(fileFilter));
        }
        for (String language : query.languages()) {
            filters.add(new FileFilterWrapper((FileFilter)this.languageFilters.forLang(language)));
        }
        for (String inclusion : query.inclusions()) {
            filters.add(new InclusionFilter(inclusion));
        }
        for (String exclusion : query.exclusions()) {
            filters.add(new ExclusionFilter(exclusion));
        }
        LinkedList result = Lists.newLinkedList();
        FileFilterContext context = new FileFilterContext(this);
        block8: for (FileType type : query.types()) {
            context.setType(type);
            switch (type) {
                case SOURCE: {
                    this.applyFilters(result, context, filters, this.sourceDirs);
                    continue block8;
                }
                case TEST: {
                    this.applyFilters(result, context, filters, this.testDirs);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown file type: " + type);
        }
        return result;
    }

    private void applyFilters(List<File> result, FileFilterContext context, Collection<FileSystemFilter> filters, Collection<File> dirs) {
        for (File dir : dirs) {
            if (!dir.exists()) continue;
            context.setRelativeDir(dir);
            Collection files = FileUtils.listFiles((File)dir, (IOFileFilter)HiddenFileFilter.VISIBLE, (IOFileFilter)DIR_FILTER);
            for (File file : files) {
                if (!this.accept(file, context, filters)) continue;
                result.add(file);
            }
        }
    }

    private boolean accept(File file, FileFilterContext context, Collection<FileSystemFilter> filters) {
        context.setRelativePath(this.pathResolver.relativePath(context.relativeDir(), file));
        try {
            context.setCanonicalPath(file.getCanonicalPath());
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get the canonical path of: " + file);
        }
        for (FileSystemFilter filter : filters) {
            if (filter.accept(file, (FileSystemFilter.Context)context)) continue;
            return false;
        }
        return true;
    }

    public void resetDirs(File basedir, File buildDir, List<File> sourceDirs, List<File> testDirs, List<File> binaryDirs) {
        Preconditions.checkNotNull((Object)basedir, (Object)"Basedir can't be null");
        this.baseDir = basedir;
        this.buildDir = buildDir;
        this.sourceDirs = this.existingDirs(sourceDirs);
        this.testDirs = this.existingDirs(testDirs);
        this.binaryDirs = this.existingDirs(binaryDirs);
    }

    private List<File> existingDirs(List<File> dirs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (File dir : dirs) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            builder.add((Object)dir);
        }
        return builder.build();
    }

    DefaultModuleFileSystem setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    DefaultModuleFileSystem setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    DefaultModuleFileSystem setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    DefaultModuleFileSystem setBuildDir(File buildDir) {
        this.buildDir = buildDir;
        return this;
    }

    DefaultModuleFileSystem addFilters(FileSystemFilter ... f) {
        for (FileSystemFilter filter : f) {
            this.fsFilters.add(filter);
        }
        return this;
    }

    DefaultModuleFileSystem setLanguageFilters(LanguageFilters languageFilters) {
        this.languageFilters = languageFilters;
        return this;
    }

    DefaultModuleFileSystem addSourceDir(File d) {
        this.sourceDirs.add(d);
        return this;
    }

    DefaultModuleFileSystem addTestDir(File d) {
        this.testDirs.add(d);
        return this;
    }

    DefaultModuleFileSystem addBinaryDir(File d) {
        this.binaryDirs.add(d);
        return this;
    }
}

