/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.task.Task;
import org.sonar.api.task.TaskDefinition;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.DefaultFileLinesContextFactory;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.ProjectConfigurator;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.bootstrap.BatchDatabase;
import org.sonar.batch.bootstrap.BatchDatabaseSessionFactory;
import org.sonar.batch.bootstrap.Container;
import org.sonar.batch.bootstrap.DatabaseCompatibility;
import org.sonar.batch.bootstrap.DryRunDatabase;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.JdbcDriverHolder;
import org.sonar.batch.bootstrap.MetricProvider;
import org.sonar.batch.bootstrap.ProjectExclusions;
import org.sonar.batch.bootstrap.ProjectLock;
import org.sonar.batch.bootstrap.ProjectReactorReady;
import org.sonar.batch.components.PastMeasuresLoader;
import org.sonar.batch.components.PastSnapshotFinder;
import org.sonar.batch.components.PastSnapshotFinderByDate;
import org.sonar.batch.components.PastSnapshotFinderByDays;
import org.sonar.batch.components.PastSnapshotFinderByPreviousAnalysis;
import org.sonar.batch.components.PastSnapshotFinderByPreviousVersion;
import org.sonar.batch.components.PastSnapshotFinderByVersion;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultPersistenceManager;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.index.DependencyPersister;
import org.sonar.batch.index.EventPersister;
import org.sonar.batch.index.LinkPersister;
import org.sonar.batch.index.MeasurePersister;
import org.sonar.batch.index.MemoryOptimizer;
import org.sonar.batch.index.SourcePersister;
import org.sonar.batch.scan.ScanTask;
import org.sonar.batch.tasks.ListTasksTask;
import org.sonar.core.component.ScanGraph;
import org.sonar.core.component.ScanGraphStore;
import org.sonar.core.component.ScanPerspectives;
import org.sonar.core.i18n.I18nManager;
import org.sonar.core.i18n.RuleI18nManager;
import org.sonar.core.metric.CacheMetricFinder;
import org.sonar.core.notification.DefaultNotificationManager;
import org.sonar.core.persistence.DaoUtils;
import org.sonar.core.persistence.DatabaseVersion;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.persistence.SemaphoreUpdater;
import org.sonar.core.persistence.SemaphoresImpl;
import org.sonar.core.resource.DefaultResourcePermissions;
import org.sonar.core.rule.CacheRuleFinder;
import org.sonar.core.test.TestPlanBuilder;
import org.sonar.core.test.TestableBuilder;
import org.sonar.core.user.DefaultUserFinder;
import org.sonar.jpa.dao.MeasuresDao;
import org.sonar.jpa.session.DefaultDatabaseConnector;
import org.sonar.jpa.session.JpaDatabaseSession;

public class TaskContainer
extends Container {
    private static final Logger LOG = LoggerFactory.getLogger(TaskContainer.class);
    private TaskDefinition taskDefinition;
    private boolean projectPresent;

    public TaskContainer(TaskDefinition task, boolean projectPresent) {
        this.taskDefinition = task;
        this.projectPresent = projectPresent;
    }

    protected void configure() {
        this.logSettings();
        this.registerCoreComponents();
        this.registerDatabaseComponents();
        this.registerCoreTasks();
        if (this.projectPresent) {
            this.registerCoreComponentsRequiringProject();
        }
        this.registerTaskExtensions();
    }

    private void registerCoreComponents() {
        this.container.addSingleton(EmailSettings.class);
        this.container.addSingleton(I18nManager.class);
        this.container.addSingleton(RuleI18nManager.class);
        this.container.addSingleton(MeasuresDao.class);
        this.container.addSingleton(CacheRuleFinder.class);
        this.container.addSingleton(CacheMetricFinder.class);
        this.container.addSingleton(DefaultUserFinder.class);
        this.container.addSingleton(ResourceTypes.class);
        this.container.addSingleton(SemaphoreUpdater.class);
        this.container.addSingleton(SemaphoresImpl.class);
        this.container.addSingleton(PastSnapshotFinderByDate.class);
        this.container.addSingleton(PastSnapshotFinderByDays.class);
        this.container.addSingleton(PastSnapshotFinderByPreviousAnalysis.class);
        this.container.addSingleton(PastSnapshotFinderByVersion.class);
        this.container.addSingleton(PastSnapshotFinderByPreviousVersion.class);
        this.container.addSingleton(PastMeasuresLoader.class);
        this.container.addSingleton(PastSnapshotFinder.class);
    }

    private void registerDatabaseComponents() {
        this.container.addSingleton(JdbcDriverHolder.class);
        this.container.addSingleton(BatchDatabase.class);
        this.container.addSingleton(MyBatis.class);
        this.container.addSingleton(DatabaseVersion.class);
        this.container.addSingleton(DatabaseCompatibility.class);
        for (Class daoClass : DaoUtils.getDaoClasses()) {
            this.container.addSingleton((Object)daoClass);
        }
        this.container.addSingleton(DefaultDatabaseConnector.class);
        this.container.addSingleton(JpaDatabaseSession.class);
        this.container.addSingleton(BatchDatabaseSessionFactory.class);
    }

    private void registerCoreTasks() {
        this.container.addSingleton(ListTasksTask.class);
        if (this.projectPresent) {
            this.container.addSingleton(ScanTask.class);
        }
    }

    private void registerTaskExtensions() {
        ExtensionInstaller installer = (ExtensionInstaller)this.container.getComponentByType(ExtensionInstaller.class);
        installer.installTaskExtensions(this.container, this.projectPresent);
    }

    private void registerCoreComponentsRequiringProject() {
        this.container.addSingleton(DefaultResourceCreationLock.class);
        this.container.addSingleton(DefaultPersistenceManager.class);
        this.container.addSingleton(DependencyPersister.class);
        this.container.addSingleton(EventPersister.class);
        this.container.addSingleton(LinkPersister.class);
        this.container.addSingleton(MeasurePersister.class);
        this.container.addSingleton(MemoryOptimizer.class);
        this.container.addSingleton(DefaultResourcePermissions.class);
        this.container.addSingleton(DefaultResourcePersister.class);
        this.container.addSingleton(SourcePersister.class);
        this.container.addSingleton(DefaultNotificationManager.class);
        this.container.addSingleton(MetricProvider.class);
        this.container.addSingleton(ProjectExclusions.class);
        this.container.addSingleton(ProjectReactorReady.class);
        this.container.addSingleton(ProjectTree.class);
        this.container.addSingleton(ProjectConfigurator.class);
        this.container.addSingleton(DefaultIndex.class);
        this.container.addSingleton(DefaultFileLinesContextFactory.class);
        this.container.addSingleton(ProjectLock.class);
        this.container.addSingleton(DryRunDatabase.class);
        this.container.addSingleton((Object)ScanGraph.create());
        this.container.addSingleton(TestPlanBuilder.class);
        this.container.addSingleton(TestableBuilder.class);
        this.container.addSingleton(ScanPerspectives.class);
        this.container.addSingleton(ScanGraphStore.class);
    }

    private void logSettings() {
        LOG.info("-------------  Executing {}", (Object)this.taskDefinition.getName());
    }

    protected void doStart() {
        Task task = (Task)this.container.getComponentByType(this.taskDefinition.getTask());
        if (task == null) {
            throw new SonarException("Extension " + this.taskDefinition.getTask() + " was not found in declared extensions.");
        }
        task.execute();
    }
}

