/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import javax.annotation.Nullable;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.picocontainer.ComponentAdapter;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.UriReader;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.BatchSettings;
import org.sonar.batch.bootstrap.BootstrapSettings;
import org.sonar.batch.bootstrap.Container;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.FileCacheProvider;
import org.sonar.batch.bootstrap.GlobalBatchProperties;
import org.sonar.batch.bootstrap.PluginDownloader;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.bootstrap.ServerMetadata;
import org.sonar.batch.bootstrap.TaskBootstrapContainer;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.batch.scan.maven.FakeMavenPluginExecutor;
import org.sonar.batch.scan.maven.MavenPluginExecutor;
import org.sonar.core.config.Logback;

public class BootstrapContainer
extends Container {
    private Object[] boostrapperComponents;
    private ProjectReactor reactor;
    private GlobalBatchProperties globalProperties;
    private String taskCommand;

    @Deprecated
    public BootstrapContainer(ProjectReactor reactor, Object ... boostrapperComponents) {
        this(new GlobalBatchProperties(), null, reactor, boostrapperComponents);
    }

    public BootstrapContainer(GlobalBatchProperties globalProperties, @Nullable String taskCommand, @Nullable ProjectReactor reactor, Object ... boostrapperComponents) {
        this.globalProperties = globalProperties;
        this.taskCommand = taskCommand;
        this.reactor = reactor;
        this.boostrapperComponents = boostrapperComponents;
    }

    protected void configure() {
        this.container.addSingleton((Object)this.globalProperties);
        if (this.reactor != null) {
            this.container.addSingleton((Object)this.reactor);
        }
        this.container.addSingleton((Object)new PropertiesConfiguration());
        this.container.addSingleton(BootstrapSettings.class);
        this.container.addSingleton(ServerClient.class);
        this.container.addSingleton(BatchSettings.class);
        this.container.addSingleton(BatchPluginRepository.class);
        this.container.addSingleton(ExtensionInstaller.class);
        this.container.addSingleton(Logback.class);
        this.container.addSingleton(ServerMetadata.class);
        this.container.addSingleton(org.sonar.batch.ServerMetadata.class);
        this.container.addSingleton(TempDirectories.class);
        this.container.addSingleton(HttpDownloader.class);
        this.container.addSingleton(UriReader.class);
        this.container.addSingleton(PluginDownloader.class);
        this.container.addPicoAdapter((ComponentAdapter)new FileCacheProvider());
        for (Object component : this.boostrapperComponents) {
            if (component == null) continue;
            this.container.addSingleton(component);
        }
        if (!this.isMavenPluginExecutorRegistered()) {
            this.container.addSingleton(FakeMavenPluginExecutor.class);
        }
    }

    boolean isMavenPluginExecutorRegistered() {
        if (this.boostrapperComponents != null) {
            for (Object component : this.boostrapperComponents) {
                if (!(component instanceof Class) || !MavenPluginExecutor.class.isAssignableFrom((Class)component)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        TaskBootstrapContainer childModule = new TaskBootstrapContainer(this.taskCommand);
        try {
            this.installChild(childModule);
            childModule.start();
        }
        finally {
            childModule.stop();
            this.uninstallChild();
        }
    }
}

