/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.design.Dependency;
import org.sonar.api.design.DependencyDto;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.batch.index.ResourcePersister;

public final class DependencyPersister {
    private ResourcePersister resourcePersister;
    private DatabaseSession session;

    public DependencyPersister(ResourcePersister resourcePersister, DatabaseSession session) {
        this.resourcePersister = resourcePersister;
        this.session = session;
    }

    public void saveDependency(Project project, Dependency dependency, Dependency parentDependency) {
        Snapshot fromSnapshot = this.resourcePersister.saveResource(project, dependency.getFrom());
        Snapshot toSnapshot = this.resourcePersister.saveResource(project, dependency.getTo());
        Snapshot projectSnapshot = this.resourcePersister.getSnapshot((Resource)project);
        DependencyDto model = new DependencyDto();
        model.setProjectSnapshotId(projectSnapshot.getId());
        model.setUsage(dependency.getUsage());
        model.setWeight(Integer.valueOf(dependency.getWeight()));
        model.setFromResourceId(fromSnapshot.getResourceId());
        model.setFromScope(fromSnapshot.getScope());
        model.setFromSnapshotId(fromSnapshot.getId());
        model.setToResourceId(toSnapshot.getResourceId());
        model.setToSnapshotId(toSnapshot.getId());
        model.setToScope(toSnapshot.getScope());
        if (parentDependency != null) {
            model.setParentDependencyId(parentDependency.getId());
        }
        this.session.save((Object)model);
        dependency.setId(model.getId());
    }
}

