/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.events;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.events.EventHandler;
import org.sonar.batch.events.BatchEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBus {
    private EventHandler[] registeredHandlers;

    public EventBus(EventHandler[] handlers) {
        this.registeredHandlers = handlers;
    }

    public void fireEvent(BatchEvent event) {
        this.doFireEvent(event);
    }

    private void doFireEvent(BatchEvent event) {
        List<EventHandler> handlers = this.getDispatchList(event.getType());
        for (EventHandler handler : handlers) {
            event.dispatch(handler);
        }
    }

    private List<EventHandler> getDispatchList(Class<? extends EventHandler> handlerType) {
        ArrayList result = Lists.newArrayList();
        for (EventHandler handler : this.registeredHandlers) {
            if (!handlerType.isAssignableFrom(handler.getClass())) continue;
            result.add(handler);
        }
        return result;
    }
}

