/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.base.Throwables;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.ProjectReactorReady;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.bootstrap.TempDirectories;

public class DryRunDatabase
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(DryRunDatabase.class);
    private static final String DIALECT = "h2";
    private static final String DRIVER = "org.h2.Driver";
    private static final String URL = "jdbc:h2:";
    private static final String USER = "sonar";
    private static final String PASSWORD = "sonar";
    private final Settings settings;
    private final ServerClient server;
    private final TempDirectories tempDirectories;
    private final ProjectReactor reactor;

    public DryRunDatabase(Settings settings, ServerClient server, TempDirectories tempDirectories, ProjectReactor reactor, ProjectReactorReady reactorReady) {
        this.settings = settings;
        this.server = server;
        this.tempDirectories = tempDirectories;
        this.reactor = reactor;
    }

    public void start() {
        if (this.settings.getBoolean("sonar.dryRun")) {
            LOG.info("Dry run");
            File databaseFile = this.tempDirectories.getFile("", "dryrun.h2.db");
            this.downloadDatabase(this.reactor.getRoot().getKey(), databaseFile);
            String databasePath = StringUtils.removeEnd((String)databaseFile.getAbsolutePath(), (String)".h2.db");
            this.replaceSettings(databasePath);
        }
    }

    private void downloadDatabase(String projectKey, File toFile) {
        try {
            this.server.download("/batch_bootstrap/db?project=" + projectKey, toFile);
        }
        catch (SonarException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof HttpDownloader.HttpException && ((HttpDownloader.HttpException)rootCause).getResponseCode() == 401) {
                throw new SonarException(String.format("You don't have access rights to project [%s]", projectKey), (Throwable)e);
            }
            throw e;
        }
    }

    private void replaceSettings(String databasePath) {
        this.settings.removeProperty("sonar.jdbc.schema").setProperty("sonar.jdbc.dialect", DIALECT).setProperty("sonar.jdbc.driverClassName", DRIVER).setProperty("sonar.jdbc.username", "sonar").setProperty("sonar.jdbc.password", "sonar").setProperty("sonar.jdbc.url", URL + databasePath);
    }
}

