/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.events.DecoratorExecutionHandler;
import org.sonar.api.batch.events.DecoratorsPhaseHandler;
import org.sonar.api.batch.events.SensorExecutionHandler;
import org.sonar.api.batch.events.SensorsPhaseHandler;
import org.sonar.api.utils.TimeProfiler;

public class PhasesTimeProfiler
implements SensorExecutionHandler,
DecoratorExecutionHandler,
DecoratorsPhaseHandler,
SensorsPhaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PhasesTimeProfiler.class);
    private TimeProfiler profiler = new TimeProfiler(LOG);
    private DecoratorsProfiler decoratorsProfiler = new DecoratorsProfiler();

    public void onSensorsPhase(SensorsPhaseHandler.SensorsPhaseEvent event) {
        if (event.isStart()) {
            LOG.debug("Sensors : {}", (Object)StringUtils.join((Collection)event.getSensors(), (String)" -> "));
        }
    }

    public void onSensorExecution(SensorExecutionHandler.SensorExecutionEvent event) {
        if (event.isStart()) {
            this.profiler.start("Sensor " + event.getSensor());
        } else {
            this.profiler.stop();
        }
    }

    public void onDecoratorExecution(DecoratorExecutionHandler.DecoratorExecutionEvent event) {
        if (event.isStart()) {
            this.decoratorsProfiler.start(event.getDecorator());
        } else {
            this.decoratorsProfiler.stop();
        }
    }

    public void onDecoratorsPhase(DecoratorsPhaseHandler.DecoratorsPhaseEvent event) {
        if (event.isStart()) {
            LOG.info("Execute decorators...");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decorators: {}", (Object)StringUtils.join((Collection)event.getDecorators(), (String)" -> "));
            }
        } else {
            this.decoratorsProfiler.log();
        }
    }

    static class DecoratorsProfiler {
        List<Decorator> decorators = Lists.newArrayList();
        Map<Decorator, Long> durations = new IdentityHashMap<Decorator, Long>();
        long startTime;
        Decorator currentDecorator;

        DecoratorsProfiler() {
        }

        void start(Decorator decorator) {
            this.startTime = System.currentTimeMillis();
            this.currentDecorator = decorator;
        }

        void stop() {
            Long cumulatedDuration;
            if (this.durations.containsKey(this.currentDecorator)) {
                cumulatedDuration = this.durations.get(this.currentDecorator);
            } else {
                this.decorators.add(this.currentDecorator);
                cumulatedDuration = 0L;
            }
            this.durations.put(this.currentDecorator, cumulatedDuration + (System.currentTimeMillis() - this.startTime));
        }

        void log() {
            LOG.debug(this.getMessage());
        }

        String getMessage() {
            StringBuilder sb = new StringBuilder("Decorator time:").append(SystemUtils.LINE_SEPARATOR);
            for (Decorator decorator : this.decorators) {
                sb.append("\t").append(decorator.toString()).append(": ").append(this.durations.get(decorator)).append("ms").append(SystemUtils.LINE_SEPARATOR);
            }
            return sb.toString();
        }
    }
}

