/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.io.IOException;
import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.RemoteServerMetadata;
import org.sonar.core.persistence.BadDatabaseVersion;
import org.sonar.core.persistence.DatabaseVersion;

public class DatabaseBatchCompatibility
implements BatchComponent {
    private DatabaseVersion version;
    private Server server;
    private Settings settings;
    private RemoteServerMetadata remoteServer;

    public DatabaseBatchCompatibility(DatabaseVersion version, Server server, RemoteServerMetadata remoteServer, Settings settings) {
        this.version = version;
        this.server = server;
        this.settings = settings;
        this.remoteServer = remoteServer;
    }

    public void start() {
        this.checkCorrectServerId();
        this.checkDatabaseStatus();
    }

    private void checkCorrectServerId() {
        String remoteServerId;
        try {
            remoteServerId = this.remoteServer.getServerId();
        }
        catch (IOException e) {
            throw new SonarException("Impossible to get the ID of the remote server: " + this.server.getURL(), (Throwable)e);
        }
        if (!this.version.getSonarCoreId().equals(remoteServerId)) {
            StringBuilder message = new StringBuilder("The current batch process and the configured remote server do not share the same DB configuration.\n");
            message.append("\t- Batch side: ");
            message.append(this.settings.getString("sonar.jdbc.url"));
            message.append(" (");
            String userName = this.settings.getString("sonar.jdbc.username");
            message.append(userName == null ? "sonar" : userName);
            message.append(" / *****)\n\t- Server side: check the configuration at ");
            message.append(this.server.getURL());
            message.append("/system\n");
            throw new BadDatabaseVersion(message.toString());
        }
    }

    private void checkDatabaseStatus() {
        DatabaseVersion.Status status = this.version.getStatus();
        if (status == DatabaseVersion.Status.REQUIRES_DOWNGRADE) {
            throw new BadDatabaseVersion("Database relates to a more recent version of Sonar. Please check your settings (JDBC settings, version of Maven plugin)");
        }
        if (status == DatabaseVersion.Status.REQUIRES_UPGRADE) {
            throw new BadDatabaseVersion("Database must be upgraded. Please browse " + this.server.getURL() + "/setup");
        }
        if (status != DatabaseVersion.Status.UP_TO_DATE) {
            throw new BadDatabaseVersion("Unknown database status: " + status);
        }
    }
}

