/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenProjectConverter {
    private MavenProjectConverter() {
    }

    public static ProjectDefinition convert(List<MavenProject> poms, MavenProject root) {
        HashMap paths = Maps.newHashMap();
        HashMap defs = Maps.newHashMap();
        try {
            for (MavenProject mavenProject : poms) {
                String basedir = mavenProject.getBasedir().getCanonicalPath();
                paths.put(basedir, mavenProject);
                defs.put(mavenProject, MavenProjectConverter.convert(mavenProject));
            }
            for (Map.Entry entry : paths.entrySet()) {
                MavenProject pom = (MavenProject)entry.getValue();
                for (Object moduleId : pom.getModules()) {
                    File modulePath = new File(pom.getBasedir(), (String)moduleId);
                    MavenProject module = (MavenProject)paths.get(modulePath.getCanonicalPath());
                    ((ProjectDefinition)defs.get(pom)).addSubProject((ProjectDefinition)defs.get(module));
                }
            }
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        return (ProjectDefinition)defs.get(root);
    }

    static ProjectDefinition convert(MavenProject pom) {
        String key = pom.getGroupId() + ":" + pom.getArtifactId();
        ProjectDefinition definition = ProjectDefinition.create((Properties)pom.getModel().getProperties());
        definition.setKey(key).setVersion(pom.getVersion()).setName(pom.getName()).setDescription(pom.getDescription()).addContainerExtension((Object)pom);
        MavenProjectConverter.synchronizeFileSystem(pom, definition);
        return definition;
    }

    public static void synchronizeFileSystem(MavenProject pom, ProjectDefinition into) {
        into.setBaseDir(pom.getBasedir());
        into.setWorkDir(new File(MavenProjectConverter.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir()), "sonar"));
        into.setSourceDirs(pom.getCompileSourceRoots().toArray(new String[pom.getCompileSourceRoots().size()]));
        into.setTestDirs(pom.getTestCompileSourceRoots().toArray(new String[pom.getTestCompileSourceRoots().size()]));
    }

    static File resolvePath(String path, File basedir) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(basedir, path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new SonarException("Unable to resolve path '" + path + "'", (Throwable)e);
            }
        }
        return file;
    }
}

