/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Reporting;
import org.apache.maven.project.MavenProject;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrapper.ProjectDefinition;

public class InMemoryPomCreator {
    private ProjectDefinition project;

    public InMemoryPomCreator(ProjectDefinition project) {
        this.project = project;
    }

    public MavenProject create() {
        File workDir = this.project.getWorkDir();
        String buildDirectory = workDir.getAbsolutePath() + "/target";
        Properties properties = this.project.getProperties();
        if (this.project.getBinaries().size() == 0) {
            this.project.addBinaryDir(buildDirectory + "/classes");
        }
        MavenProject pom = new MavenProject(){

            public File getBasedir() {
                return InMemoryPomCreator.this.project.getBaseDir();
            }

            public List<String> getCompileClasspathElements() throws DependencyResolutionRequiredException {
                ArrayList<String> cp = new ArrayList<String>();
                cp.addAll(InMemoryPomCreator.this.project.getBinaries());
                cp.addAll(InMemoryPomCreator.this.project.getLibraries());
                return cp;
            }
        };
        String key = InMemoryPomCreator.getPropertyOrDie(properties, "sonar.projectKey");
        String[] keys = key.split(":");
        pom.setGroupId(keys[0]);
        pom.setArtifactId(keys[1]);
        pom.setVersion(InMemoryPomCreator.getPropertyOrDie(properties, "sonar.projectVersion"));
        pom.setName(properties.getProperty("sonar.projectName", "Unnamed - " + key));
        pom.setDescription(properties.getProperty("sonar.projectDescription", ""));
        pom.getModel().setProperties(properties);
        pom.setArtifacts(Collections.EMPTY_SET);
        pom.getBuild().setDirectory(buildDirectory);
        pom.getBuild().setOutputDirectory(this.project.getBinaries().get(0));
        Reporting reporting = new Reporting();
        String reportingOutputDirectory = buildDirectory + "/site";
        reporting.setOutputDirectory(reportingOutputDirectory);
        pom.setReporting(reporting);
        for (String dir : this.project.getSourceDirs()) {
            pom.addCompileSourceRoot(dir);
        }
        for (String dir : this.project.getTestDirs()) {
            pom.addTestCompileSourceRoot(dir);
        }
        return pom;
    }

    private static String getPropertyOrDie(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (StringUtils.isBlank((String)value)) {
            throw new SonarException("Property '" + key + "' must be specified");
        }
        return value;
    }
}

