/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.ExtensionDownloader;

public class BootstrapClassLoader {
    private URLClassLoader classLoader;

    public BootstrapClassLoader(ExtensionDownloader extensionDownloader) {
        this(extensionDownloader.downloadJdbcDriver());
    }

    BootstrapClassLoader(File jdbcDriver) {
        try {
            ClassLoader parentClassLoader = BootstrapClassLoader.class.getClassLoader();
            this.classLoader = URLClassLoader.newInstance(new URL[]{jdbcDriver.toURI().toURL()}, parentClassLoader);
        }
        catch (MalformedURLException e) {
            throw new SonarException("Fail to get URL of : " + jdbcDriver.getAbsolutePath(), (Throwable)e);
        }
    }

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }
}

