/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.indexer;

import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Library;
import org.sonar.batch.indexer.Bucket;
import org.sonar.batch.indexer.ResourcePersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryPersister
extends ResourcePersister<Library> {
    private Date now;

    public LibraryPersister(DatabaseSession session) {
        super(session);
        this.now = new Date();
    }

    LibraryPersister(DatabaseSession session, Date now) {
        super(session);
        this.now = now;
    }

    @Override
    protected String generateEffectiveKey(Bucket<Library> bucket) {
        return bucket.getResource().getKey();
    }

    @Override
    protected void prepareResourceModel(ResourceModel resourceModel, Bucket<Library> bucket) {
    }

    @Override
    protected Snapshot createSnapshot(Bucket<Library> bucket, ResourceModel resourceModel) {
        Snapshot snapshot = this.findProject(resourceModel.getId(), bucket.getResource().getVersion());
        if (snapshot == null) {
            snapshot = this.findLibrary(resourceModel.getId(), bucket.getResource().getVersion());
        }
        if (snapshot == null) {
            snapshot = new Snapshot(resourceModel, null);
            snapshot.setCreatedAt(this.now);
            snapshot.setVersion(bucket.getResource().getVersion());
            snapshot.setStatus("P");
            snapshot.setQualifier("LIB");
        }
        return snapshot;
    }

    private Snapshot findLibrary(Integer resourceId, String version) {
        List snapshots = this.getSession().getResults(Snapshot.class, new Object[]{"resourceId", resourceId, "version", version, "scope", "PRJ", "qualifier", "LIB"});
        if (snapshots.isEmpty()) {
            return null;
        }
        return (Snapshot)snapshots.get(0);
    }

    private Snapshot findProject(Integer resourceId, String version) {
        Query query = this.getSession().createQuery("from " + Snapshot.class.getSimpleName() + " s WHERE s.resourceId=:resourceId AND s.version=:version AND s.scope=:scope AND s.qualifier<>:qualifier AND s.last=:last");
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("version", (Object)version);
        query.setParameter("scope", (Object)"PRJ");
        query.setParameter("qualifier", (Object)"LIB");
        query.setParameter("last", (Object)Boolean.TRUE);
        List snapshots = query.getResultList();
        if (snapshots.isEmpty()) {
            return null;
        }
        return (Snapshot)snapshots.get(0);
    }
}

