/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.apache.commons.configuration.Configuration;
import org.sonar.batch.ServerMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteClassLoader {
    private URLClassLoader classLoader;

    public RemoteClassLoader(URL[] urls, ClassLoader parent) {
        ClassLoader parentClassLoader = parent == null ? RemoteClassLoader.class.getClassLoader() : parent;
        this.classLoader = URLClassLoader.newInstance(urls, parentClassLoader);
    }

    public RemoteClassLoader(URL[] urls) {
        this(urls, null);
    }

    public RemoteClassLoader(Collection<URL> urls, ClassLoader parent) {
        this(urls.toArray(new URL[urls.size()]), parent);
    }

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static RemoteClassLoader createForJdbcDriver(Configuration conf) {
        String baseUrl = ServerMetadata.getURL(conf);
        String url = baseUrl + "/deploy/jdbc-driver.jar";
        try {
            return new RemoteClassLoader(new URL[]{new URL(url)});
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Fail to download the JDBC driver from server: " + url, e);
        }
    }
}

