/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.Properties;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.daos.AsyncMeasuresDao;
import org.sonar.api.database.daos.AsyncMeasuresService;
import org.sonar.api.database.daos.DaoFacade;
import org.sonar.api.database.daos.MeasuresDao;
import org.sonar.api.database.daos.ProfilesDao;
import org.sonar.api.database.daos.RulesDao;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.RulesManager;
import org.sonar.api.utils.IocContainer;
import org.sonar.batch.BatchPluginRepository;
import org.sonar.batch.CheckProfileProvider;
import org.sonar.batch.CoreJob;
import org.sonar.batch.CoreJobs;
import org.sonar.batch.DefaultSensorContext;
import org.sonar.batch.DefaultTimeMachine;
import org.sonar.batch.ProfileProvider;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.ViolationsDao;
import org.sonar.batch.indexer.DefaultSonarIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBatch {
    private MutablePicoContainer globalContainer;
    private MutablePicoContainer batchContainer;

    public ProjectBatch(MutablePicoContainer container) {
        this.globalContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DefaultSonarIndex index, Project project) {
        try {
            this.startChildContainer(index, project);
            SensorContext sensorContext = (SensorContext)this.batchContainer.getComponent(SensorContext.class);
            for (Class<? extends CoreJob> clazz : CoreJobs.allJobs()) {
                CoreJob job = this.getComponent(clazz);
                job.execute(project, sensorContext);
                this.commit();
            }
        }
        finally {
            index.clear();
            this.stop();
        }
    }

    public void startChildContainer(DefaultSonarIndex index, Project project) {
        this.batchContainer = this.globalContainer.makeChildContainer();
        ((BatchPluginRepository)((Object)this.batchContainer.getComponent(BatchPluginRepository.class))).registerPlugins(this.batchContainer);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)project);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)project.getPom());
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ProjectClasspath.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)index.getBucket((Resource)project).getSnapshot());
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)project.getConfiguration());
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DaoFacade.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(RulesDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(MeasuresDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ProfilesDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(AsyncMeasuresDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(AsyncMeasuresService.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(RulesManager.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultSensorContext.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(Languages.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(BatchExtensionDictionnary.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultTimeMachine.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ViolationsDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ViolationFilters.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ResourceFilters.class);
        this.batchContainer.addAdapter((ComponentAdapter)new ProfileProvider());
        this.batchContainer.addAdapter((ComponentAdapter)new CheckProfileProvider());
        this.loadCoreComponents(this.batchContainer);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)new IocContainer(this.batchContainer));
        this.batchContainer.start();
        project.setLanguage(this.getComponent(Languages.class).get(project.getLanguageKey()));
        index.selectProject(project, this.getComponent(ResourceFilters.class), this.getComponent(ViolationFilters.class), this.getComponent(MeasuresDao.class), this.getComponent(ViolationsDao.class));
    }

    private void loadCoreComponents(MutablePicoContainer container) {
        for (Class<? extends CoreJob> clazz : CoreJobs.allJobs()) {
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(clazz);
        }
        for (Metric metric : CoreMetrics.getMetrics()) {
            container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)metric.getKey(), (Object)metric, new Parameter[0]);
        }
        for (Metrics metricRepo : container.getComponents(Metrics.class)) {
            for (Metric metric : metricRepo.getMetrics()) {
                container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)metric.getKey(), (Object)metric, new Parameter[0]);
            }
        }
    }

    private void stop() {
        if (this.batchContainer != null) {
            this.commit();
            try {
                this.globalContainer.removeChildContainer((PicoContainer)this.batchContainer);
                this.batchContainer.stop();
                this.batchContainer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void commit() {
        this.getComponent(DatabaseSession.class).commit();
    }

    public <T> T getComponent(Class<T> clazz) {
        if (this.batchContainer != null) {
            return (T)this.batchContainer.getComponent(clazz);
        }
        return (T)this.globalContainer.getComponent(clazz);
    }
}

