/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.ArrayListMultimap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picocontainer.MutablePicoContainer;
import org.sonar.api.BatchExtension;
import org.sonar.api.Plugin;
import org.sonar.api.platform.LocalExtension;
import org.sonar.api.platform.LocalExtensionFile;
import org.sonar.api.platform.LocalExtensionRegistry;
import org.sonar.api.platform.PluginRepository;
import org.sonar.batch.RemoteClassLoader;
import org.sonar.batch.ServerMetadata;

public class BatchPluginRepository
extends PluginRepository {
    private Map<String, ClassLoader> classloaders;
    private String baseUrl;
    private LocalExtensionRegistry localExtensionRegistry;

    public BatchPluginRepository(LocalExtensionRegistry localExtensionRegistry, ServerMetadata server) {
        this.localExtensionRegistry = localExtensionRegistry;
        this.baseUrl = server.getUrl() + "/deploy/plugins/";
    }

    public void start() {
        ArrayListMultimap urlsByKey = ArrayListMultimap.create();
        for (LocalExtensionFile extensionFile : this.localExtensionRegistry.getFiles()) {
            try {
                String key = this.getClassloaderKey(extensionFile.getPluginKey());
                URL url = new URL(this.baseUrl + extensionFile.getPath());
                urlsByKey.put((Object)key, (Object)url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Can not build the classloader of the plugin " + extensionFile.getPluginKey(), e);
            }
        }
        this.classloaders = new HashMap<String, ClassLoader>();
        for (String key : urlsByKey.keys()) {
            List urls = urlsByKey.get((Object)key);
            this.classloaders.put(key, new RemoteClassLoader(urls, Thread.currentThread().getContextClassLoader()).getClassLoader());
        }
    }

    private String getClassloaderKey(String pluginKey) {
        return "sonar-plugin-" + pluginKey;
    }

    public void registerPlugins(MutablePicoContainer pico) {
        try {
            for (LocalExtension pluginMetadata : this.localExtensionRegistry.getPlugins()) {
                String classloaderKey = this.getClassloaderKey(pluginMetadata.getPluginKey());
                Class<?> claz = this.classloaders.get(classloaderKey).loadClass(pluginMetadata.getPluginClass());
                Plugin plugin = (Plugin)claz.newInstance();
                this.registerPlugin(pico, plugin, BatchExtension.class);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

