/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;

public class MavenPluginsConfigurator
implements BatchComponent {
    private BatchExtensionDictionnary dictionnary = null;

    public MavenPluginsConfigurator(BatchExtensionDictionnary dictionnary) {
        this.dictionnary = dictionnary;
    }

    public void execute(Project project) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("Configure maven plugins...");
        for (MavenPluginHandler handler : this.dictionnary.selectMavenPluginHandlers(project)) {
            logger.debug("Configure {}...", (Object)handler);
            this.configureHandler(project, handler);
        }
        this.savePom(project);
    }

    protected void configureHandler(Project project, MavenPluginHandler handler) {
        MavenPlugin plugin = MavenPlugin.registerPlugin((MavenProject)project.getPom(), (String)handler.getGroupId(), (String)handler.getArtifactId(), (String)handler.getVersion(), (boolean)handler.isFixedVersion());
        handler.configure(project, plugin);
    }

    protected void savePom(Project project) {
        MavenProject pom = project.getPom();
        if (pom != null) {
            File targetPom = new File(project.getFileSystem().getSonarWorkingDirectory(), "sonar-pom.xml");
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(targetPom, false);
                pom.writeModel((Writer)fileWriter);
            }
            catch (IOException e) {
                try {
                    throw new SonarException("Can not save pom to " + targetPom, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileWriter);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }
}

