/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.ActiveRule;
import org.sonar.batch.ProfileLoader;
import org.sonar.jpa.dao.ProfilesDao;

public class DefaultProfileLoader
implements ProfileLoader {
    static final String PARAM_PROFILE = "sonar.profile";
    private ProfilesDao dao;

    public DefaultProfileLoader(ProfilesDao dao) {
        this.dao = dao;
    }

    public RulesProfile load(Project project) {
        RulesProfile profile;
        String profileName = (String)project.getProperty(PARAM_PROFILE);
        if (profileName == null) {
            Project root = project.getRoot();
            profile = this.dao.getActiveProfile(root.getLanguageKey(), root.getKey());
            if (profile == null) {
                throw new RuntimeException("Quality profile not found for " + root.getKey() + ", language " + root.getLanguageKey());
            }
        } else {
            profile = this.dao.getProfile(project.getLanguageKey(), profileName);
            if (profile == null) {
                throw new RuntimeException("Quality profile not found : " + profileName + ", language " + project.getLanguageKey());
            }
        }
        profile.getActiveRules().size();
        for (ActiveRule activeRule : profile.getActiveRules()) {
            activeRule.getActiveRuleParams().size();
            activeRule.getRule().getParams().size();
        }
        profile.getAlerts().size();
        return profile;
    }
}

