/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.platform.PluginMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Module {
    ComponentContainer container;

    public final Module init() {
        return this.init(new ComponentContainer());
    }

    private Module init(ComponentContainer container) {
        this.container = container;
        this.configure();
        return this;
    }

    public final Module install(Module module) {
        module.init(this.container);
        return this;
    }

    public final Module installChild(Module child) {
        ComponentContainer childContainer = this.container.createChild();
        child.init(childContainer);
        return child;
    }

    public final void uninstallChild() {
        this.container.removeChild();
    }

    public final Module start() {
        this.container.startComponents();
        this.doStart();
        return this;
    }

    protected void doStart() {
    }

    public final Module stop() {
        try {
            this.doStop();
            this.container.stopComponents();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    protected void doStop() {
    }

    protected abstract void configure();

    protected final void addCoreSingleton(Object component) {
        this.container.addSingleton(component);
    }

    protected final void declareExtension(PluginMetadata plugin, Object extension) {
        this.container.declareExtension(plugin, extension);
    }

    protected final void addExtension(PluginMetadata plugin, Object extension) {
        this.container.addExtension(plugin, extension);
    }

    protected final void addAdapter(ComponentAdapter<?> componentAdapter) {
        this.container.addPicoAdapter(componentAdapter);
    }

    public final <T> T getComponentByType(Class<T> componentType) {
        return (T)this.container.getComponentByType(componentType);
    }

    public final Object getComponentByKey(Object key) {
        return this.container.getComponentByKey(key);
    }

    public final <T> List<T> getComponents(Class<T> componentType) {
        return this.container.getComponentsByType(componentType);
    }
}

