/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Event;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectLink;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.resources.Scopes;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.SonarException;
import org.sonar.api.violations.ViolationQuery;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.index.Bucket;
import org.sonar.batch.index.PersistenceManager;
import org.sonar.batch.index.ResourceNotIndexedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIndex
extends SonarIndex {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndex.class);
    private RulesProfile profile;
    private PersistenceManager persistence;
    private DefaultResourceCreationLock lock;
    private MetricFinder metricFinder;
    private ViolationFilters violationFilters;
    private ResourceFilters resourceFilters;
    private Project currentProject;
    private Map<Resource, Bucket> buckets = Maps.newHashMap();
    private Set<Dependency> dependencies = Sets.newHashSet();
    private Map<Resource, Map<Resource, Dependency>> outgoingDependenciesByResource = Maps.newHashMap();
    private Map<Resource, Map<Resource, Dependency>> incomingDependenciesByResource = Maps.newHashMap();
    private ProjectTree projectTree;

    public DefaultIndex(PersistenceManager persistence, DefaultResourceCreationLock lock, ProjectTree projectTree, MetricFinder metricFinder) {
        this.persistence = persistence;
        this.lock = lock;
        this.projectTree = projectTree;
        this.metricFinder = metricFinder;
    }

    public void start() {
        Project rootProject = this.projectTree.getRootProject();
        this.doStart(rootProject);
    }

    void doStart(Project rootProject) {
        Bucket bucket = new Bucket((Resource)rootProject);
        this.buckets.put((Resource)rootProject, bucket);
        this.persistence.saveProject(rootProject, null);
        this.currentProject = rootProject;
        for (Project project : rootProject.getModules()) {
            this.addProject(project);
        }
    }

    private void addProject(Project project) {
        this.addResource((Resource)project);
        for (Project module : project.getModules()) {
            this.addProject(module);
        }
    }

    public Project getProject() {
        return this.currentProject;
    }

    public void setCurrentProject(Project project, ResourceFilters resourceFilters, ViolationFilters violationFilters, RulesProfile profile) {
        this.currentProject = project;
        this.resourceFilters = resourceFilters;
        this.violationFilters = violationFilters;
        this.profile = profile;
    }

    public void clear() {
        Iterator<Map.Entry<Resource, Bucket>> it = this.buckets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Resource, Bucket> entry = it.next();
            Resource resource = entry.getKey();
            if (ResourceUtils.isSet((Resource)resource)) continue;
            entry.getValue().clear();
            it.remove();
        }
        Set<Dependency> projectDependencies = this.getDependenciesBetweenProjects();
        this.dependencies.clear();
        this.incomingDependenciesByResource.clear();
        this.outgoingDependenciesByResource.clear();
        for (Dependency projectDependency : projectDependencies) {
            projectDependency.setId(null);
            this.registerDependency(projectDependency);
        }
        this.lock.unlock();
    }

    public Measure getMeasure(Resource resource, Metric metric) {
        Measure measure;
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null && (measure = (Measure)bucket.getMeasures(MeasuresFilters.metric((Metric)metric))) != null) {
            return this.persistence.reloadMeasure(measure);
        }
        return null;
    }

    public <M> M getMeasures(Resource resource, MeasuresFilter<M> filter) {
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null) {
            return bucket.getMeasures(filter);
        }
        return null;
    }

    public Measure addMeasure(Resource resource, Measure measure) {
        Bucket bucket = this.checkIndexed(resource);
        if (bucket != null && !bucket.isExcluded()) {
            Metric metric = this.metricFinder.findByKey(measure.getMetricKey());
            if (metric == null) {
                throw new SonarException("Unknown metric: " + measure.getMetricKey());
            }
            measure.setMetric(metric);
            bucket.addMeasure(measure);
            if (measure.getPersistenceMode().useDatabase()) {
                this.persistence.saveMeasure(resource, measure);
            }
        }
        return measure;
    }

    public Dependency addDependency(Dependency dependency) {
        Dependency existingDep = this.getEdge(dependency.getFrom(), dependency.getTo());
        if (existingDep != null) {
            return existingDep;
        }
        Dependency parentDependency = dependency.getParent();
        if (parentDependency != null) {
            this.addDependency(parentDependency);
        }
        if (this.registerDependency(dependency)) {
            this.persistence.saveDependency(this.currentProject, dependency, parentDependency);
        }
        return dependency;
    }

    boolean registerDependency(Dependency dependency) {
        Bucket fromBucket = this.doIndex(dependency.getFrom());
        Bucket toBucket = this.doIndex(dependency.getTo());
        if (fromBucket != null && !fromBucket.isExcluded() && toBucket != null && !toBucket.isExcluded()) {
            this.dependencies.add(dependency);
            this.registerOutgoingDependency(dependency);
            this.registerIncomingDependency(dependency);
            return true;
        }
        return false;
    }

    private void registerOutgoingDependency(Dependency dependency) {
        Map<Resource, Dependency> outgoingDeps = this.outgoingDependenciesByResource.get(dependency.getFrom());
        if (outgoingDeps == null) {
            outgoingDeps = new HashMap<Resource, Dependency>();
            this.outgoingDependenciesByResource.put(dependency.getFrom(), outgoingDeps);
        }
        outgoingDeps.put(dependency.getTo(), dependency);
    }

    private void registerIncomingDependency(Dependency dependency) {
        Map<Resource, Dependency> incomingDeps = this.incomingDependenciesByResource.get(dependency.getTo());
        if (incomingDeps == null) {
            incomingDeps = new HashMap<Resource, Dependency>();
            this.incomingDependenciesByResource.put(dependency.getTo(), incomingDeps);
        }
        incomingDeps.put(dependency.getFrom(), dependency);
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Dependency getEdge(Resource from, Resource to) {
        Map<Resource, Dependency> map = this.outgoingDependenciesByResource.get(from);
        if (map != null) {
            return map.get(to);
        }
        return null;
    }

    public boolean hasEdge(Resource from, Resource to) {
        return this.getEdge(from, to) != null;
    }

    public Set<Resource> getVertices() {
        return this.buckets.keySet();
    }

    public Collection<Dependency> getOutgoingEdges(Resource from) {
        Map<Resource, Dependency> deps = this.outgoingDependenciesByResource.get(from);
        if (deps != null) {
            return deps.values();
        }
        return Collections.emptyList();
    }

    public Collection<Dependency> getIncomingEdges(Resource to) {
        Map<Resource, Dependency> deps = this.incomingDependenciesByResource.get(to);
        if (deps != null) {
            return deps.values();
        }
        return Collections.emptyList();
    }

    Set<Dependency> getDependenciesBetweenProjects() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (Dependency dependency : this.dependencies) {
            if (!ResourceUtils.isSet((Resource)dependency.getFrom()) && !ResourceUtils.isSet((Resource)dependency.getTo())) continue;
            result.add(dependency);
        }
        return result;
    }

    public List<Violation> getViolations(ViolationQuery violationQuery) {
        Resource resource = violationQuery.getResource();
        if (resource == null) {
            throw new IllegalArgumentException("A resource must be set on the ViolationQuery in order to search for violations.");
        }
        Bucket bucket = this.buckets.get(resource);
        if (bucket == null) {
            return Collections.emptyList();
        }
        ArrayList filteredViolations = Lists.newArrayList();
        ViolationQuery.SwitchMode mode = violationQuery.getSwitchMode();
        for (Violation violation : bucket.getViolations()) {
            if (mode != ViolationQuery.SwitchMode.BOTH && (mode != ViolationQuery.SwitchMode.OFF || !violation.isSwitchedOff()) && (mode != ViolationQuery.SwitchMode.ON || violation.isSwitchedOff())) continue;
            filteredViolations.add(violation);
        }
        return filteredViolations;
    }

    public void addViolation(Violation violation, boolean force) {
        Resource resource = violation.getResource();
        if (resource == null) {
            violation.setResource((Resource)this.currentProject);
        } else if (!Scopes.isHigherThanOrEquals((Resource)resource, (String)"FIL")) {
            throw new IllegalArgumentException("Violations are only supported on files, directories and project");
        }
        if (violation.getRule() == null) {
            LOG.warn("Rule is null, ignoring violation {}", (Object)violation);
            return;
        }
        Bucket bucket = this.checkIndexed(resource);
        if (bucket != null && !bucket.isExcluded()) {
            boolean isIgnored;
            boolean bl = isIgnored = !force && this.violationFilters != null && this.violationFilters.isIgnored(violation);
            if (!isIgnored) {
                ActiveRule activeRule = this.profile.getActiveRule(violation.getRule());
                if (activeRule == null) {
                    if (this.currentProject.getReuseExistingRulesConfig()) {
                        violation.setSeverity(violation.getRule().getSeverity());
                        this.doAddViolation(violation, bucket);
                    } else {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("Rule is not activated, ignoring violation {}", (Object)violation);
                    }
                } else {
                    violation.setSeverity(activeRule.getSeverity());
                    this.doAddViolation(violation, bucket);
                }
            }
        }
    }

    private void doAddViolation(Violation violation, Bucket bucket) {
        bucket.addViolation(violation);
    }

    public void addLink(ProjectLink link) {
        this.persistence.saveLink(this.currentProject, link);
    }

    public void deleteLink(String key) {
        this.persistence.deleteLink(this.currentProject, key);
    }

    public List<Event> getEvents(Resource resource) {
        return this.persistence.getEvents(resource);
    }

    public void deleteEvent(Event event) {
        this.persistence.deleteEvent(event);
    }

    public Event addEvent(Resource resource, String name, String description, String category, Date date) {
        Event event = new Event(name, description, category);
        event.setDate(date);
        event.setCreatedAt(new Date());
        this.persistence.saveEvent(resource, event);
        return null;
    }

    public void setSource(Resource reference, String source) {
        Bucket bucket = this.checkIndexed(reference);
        if (bucket != null && !bucket.isExcluded()) {
            this.persistence.setSource(reference, source);
        }
    }

    public String getSource(Resource resource) {
        return this.persistence.getSource(resource);
    }

    public Resource addResource(Resource resource) {
        Bucket bucket = this.doIndex(resource);
        return bucket != null ? bucket.getResource() : null;
    }

    public <R extends Resource> R getResource(R reference) {
        Bucket bucket = this.buckets.get(reference);
        if (bucket != null) {
            return (R)bucket.getResource();
        }
        return null;
    }

    static String createUID(Project project, Resource resource) {
        String uid = resource.getKey();
        if (!StringUtils.equals((String)"PRJ", (String)resource.getScope())) {
            uid = new StringBuilder(400).append(project.getKey()).append(':').append(resource.getKey()).toString();
        }
        return uid;
    }

    private boolean checkExclusion(Resource resource, Bucket parent) {
        boolean excluded = parent != null && parent.isExcluded() || this.resourceFilters != null && this.resourceFilters.isExcluded(resource);
        resource.setExcluded(excluded);
        return excluded;
    }

    public List<Resource> getChildren(Resource resource) {
        return this.getChildren(resource, false);
    }

    public List<Resource> getChildren(Resource resource, boolean acceptExcluded) {
        LinkedList children = Lists.newLinkedList();
        Bucket bucket = this.getBucket(resource, acceptExcluded);
        if (bucket != null) {
            for (Bucket childBucket : bucket.getChildren()) {
                if (!acceptExcluded && childBucket.isExcluded()) continue;
                children.add(childBucket.getResource());
            }
        }
        return children;
    }

    public Resource getParent(Resource resource) {
        Bucket bucket = this.getBucket(resource, false);
        if (bucket != null && bucket.getParent() != null) {
            return bucket.getParent().getResource();
        }
        return null;
    }

    public boolean index(Resource resource) {
        Bucket bucket = this.doIndex(resource);
        return bucket != null && !bucket.isExcluded();
    }

    private Bucket doIndex(Resource resource) {
        if (resource.getParent() != null) {
            this.doIndex(resource.getParent());
        }
        return this.doIndex(resource, resource.getParent());
    }

    public boolean index(Resource resource, Resource parentReference) {
        Bucket bucket = this.doIndex(resource, parentReference);
        return bucket != null && !bucket.isExcluded();
    }

    private Bucket doIndex(Resource resource, Resource parentReference) {
        Bucket parentBucket;
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null) {
            return bucket;
        }
        this.checkLock(resource);
        Resource parent = null;
        if (!ResourceUtils.isLibrary((Resource)resource)) {
            parent = (Resource)ObjectUtils.defaultIfNull((Object)parentReference, (Object)this.currentProject);
        }
        if ((parentBucket = this.getBucket(parent, true)) == null && parent != null) {
            LOG.warn("Resource ignored, parent is not indexed: " + resource);
            return null;
        }
        resource.setEffectiveKey(DefaultIndex.createUID(this.currentProject, resource));
        bucket = new Bucket(resource).setParent(parentBucket);
        this.buckets.put(resource, bucket);
        boolean excluded = this.checkExclusion(resource, parentBucket);
        if (!excluded) {
            this.persistence.saveResource(this.currentProject, resource, parentBucket != null ? parentBucket.getResource() : null);
        }
        return bucket;
    }

    private void checkLock(Resource resource) {
        if (this.lock.isLocked() && !ResourceUtils.isLibrary((Resource)resource) && this.lock.isFailWhenLocked()) {
            throw new SonarException("Index is locked, resource can not be indexed: " + resource);
        }
    }

    private Bucket checkIndexed(Resource resource) {
        Bucket bucket = this.getBucket(resource, true);
        if (bucket == null) {
            if (this.lock.isLocked()) {
                if (this.lock.isFailWhenLocked()) {
                    throw new ResourceNotIndexedException(resource);
                }
                LOG.warn("Resource will be ignored in next Sonar versions, index is locked: " + resource);
            }
            if (Scopes.isDirectory((Resource)resource) || Scopes.isFile((Resource)resource)) {
                bucket = this.doIndex(resource);
            } else if (!this.lock.isLocked()) {
                LOG.warn("Resource will be ignored in next Sonar versions, it must be indexed before adding data: " + resource);
            }
        }
        return bucket;
    }

    public boolean isExcluded(Resource reference) {
        Bucket bucket = this.getBucket(reference, true);
        return bucket != null && bucket.isExcluded();
    }

    public boolean isIndexed(Resource reference, boolean acceptExcluded) {
        return this.getBucket(reference, acceptExcluded) != null;
    }

    private Bucket getBucket(Resource resource, boolean acceptExcluded) {
        Bucket bucket = null;
        if (resource != null) {
            bucket = this.buckets.get(resource);
            if (!acceptExcluded && bucket != null && bucket.isExcluded()) {
                bucket = null;
            }
        }
        return bucket;
    }
}

