/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;

public class ProjectFilter {
    private Settings settings;

    public ProjectFilter(Settings settings) {
        this.settings = settings;
    }

    public boolean isExcluded(Project project) {
        for (Project p = project; p != null; p = p.getParent()) {
            if (!this.isExcluded(ProjectFilter.getArtifactId(p))) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(String artifactId) {
        Object[] includedArtifactIds = this.settings.getStringArray("sonar.includedModules");
        if (includedArtifactIds.length > 0) {
            return !ArrayUtils.contains((Object[])includedArtifactIds, (Object)artifactId);
        }
        Object[] excludedArtifactIds = this.settings.getStringArray("sonar.skippedModules");
        return ArrayUtils.contains((Object[])excludedArtifactIds, (Object)artifactId);
    }

    static String getArtifactId(Project project) {
        String key = project.getKey();
        if (StringUtils.isNotBlank((String)project.getBranch())) {
            key = StringUtils.removeEnd((String)project.getKey(), (String)(":" + project.getBranch()));
        }
        if (key.contains(":")) {
            return StringUtils.substringAfter((String)key, (String)":");
        }
        return key;
    }
}

