/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.indexer;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.batch.indexer.Bucket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourcePersister<RESOURCE extends Resource> {
    private DatabaseSession session;

    public ResourcePersister(DatabaseSession session) {
        this.session = session;
    }

    protected DatabaseSession getSession() {
        return this.session;
    }

    public final void persist(Bucket<RESOURCE> bucket) {
        String effectiveKey = this.generateEffectiveKey(bucket);
        ResourceModel model = (ResourceModel)this.session.getSingleResult(ResourceModel.class, new Object[]{"key", effectiveKey});
        RESOURCE resource = bucket.getResource();
        if (model == null) {
            model = ResourceModel.build(resource);
            model.setKey(effectiveKey);
        } else {
            model.setEnabled(Boolean.valueOf(true));
            if (StringUtils.isNotBlank((String)resource.getName())) {
                model.setName(resource.getName());
            }
            if (StringUtils.isNotBlank((String)resource.getLongName())) {
                model.setLongName(resource.getLongName());
            }
            if (StringUtils.isNotBlank((String)resource.getDescription())) {
                model.setDescription(resource.getDescription());
            }
            if (!ResourceUtils.isLibrary(resource)) {
                model.setScope(resource.getScope());
                model.setQualifier(resource.getQualifier());
            }
            if (resource.getLanguage() != null) {
                model.setLanguageKey(resource.getLanguage().getKey());
            }
        }
        this.prepareResourceModel(model, bucket);
        model = (ResourceModel)this.session.save((Object)model);
        resource.setId(model.getId());
        resource.setEffectiveKey(model.getKey());
        Snapshot snapshot = this.createSnapshot(bucket, model);
        if (snapshot.getId() == null) {
            this.session.save((Object)snapshot);
        }
        bucket.setSnapshot(snapshot);
    }

    protected abstract void prepareResourceModel(ResourceModel var1, Bucket<RESOURCE> var2);

    protected abstract Snapshot createSnapshot(Bucket<RESOURCE> var1, ResourceModel var2);

    protected abstract String generateEffectiveKey(Bucket<RESOURCE> var1);
}

