/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.batch.CoreJob;
import org.sonar.batch.MavenPluginExecutor;

public class SensorsExecutor
implements CoreJob {
    private static final Logger logger = LoggerFactory.getLogger(SensorsExecutor.class);
    private Collection<Sensor> sensors;
    private DatabaseSession session;
    private MavenPluginExecutor mavenExecutor;

    public SensorsExecutor(BatchExtensionDictionnary selector, Project project, DatabaseSession session, MavenPluginExecutor mavenExecutor) {
        this.sensors = selector.select(Sensor.class, project, true);
        this.session = session;
        this.mavenExecutor = mavenExecutor;
    }

    public void execute(Project project, SensorContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Sensors : {}", (Object)StringUtils.join(this.sensors, (String)" -> "));
        }
        for (Sensor sensor : this.sensors) {
            this.executeMavenPlugin(project, sensor);
            TimeProfiler profiler = new TimeProfiler(logger).start("Sensor " + sensor);
            sensor.analyse(project, context);
            this.session.commit();
            profiler.stop();
        }
    }

    private void executeMavenPlugin(Project project, Sensor sensor) {
        MavenPluginHandler handler;
        if (sensor instanceof DependsUponMavenPlugin && (handler = ((DependsUponMavenPlugin)sensor).getMavenPluginHandler(project)) != null) {
            TimeProfiler profiler = new TimeProfiler(logger).start("Execute maven plugin " + handler.getArtifactId());
            this.mavenExecutor.execute(project, handler);
            profiler.stop();
        }
    }
}

