/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.Event;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Violation;
import org.sonar.batch.ViolationsDao;
import org.sonar.batch.indexer.Bucket;
import org.sonar.batch.indexer.DefaultSonarIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDecoratorContext
implements DecoratorContext {
    private DatabaseSession session;
    private DefaultSonarIndex index;
    private Resource resource;
    private boolean readOnly = false;
    private List<DecoratorContext> childrenContexts;
    private List<Violation> violations;
    private ViolationsDao violationsDao;

    public DefaultDecoratorContext(Resource resource, DefaultSonarIndex index, List<DecoratorContext> childrenContexts, DatabaseSession session, ViolationsDao violationsDao) {
        this.index = index;
        this.session = session;
        this.resource = resource;
        this.childrenContexts = childrenContexts;
        this.violationsDao = violationsDao;
    }

    public DefaultDecoratorContext setReadOnly(boolean b) {
        this.readOnly = b;
        this.violations = null;
        this.childrenContexts = null;
        return this;
    }

    public Project getProject() {
        return this.index.getProject();
    }

    public List<DecoratorContext> getChildren() {
        this.checkReadOnly("getModules");
        return this.childrenContexts;
    }

    private void checkReadOnly(String methodName) {
        if (this.readOnly) {
            throw new IllegalStateException("Method DecoratorContext." + methodName + "() can not be executed on children.");
        }
    }

    public <M> M getMeasures(MeasuresFilter<M> filter) {
        return this.index.getMeasures(this.resource, filter);
    }

    public Measure getMeasure(Metric metric) {
        return (Measure)this.index.getMeasures(this.resource, MeasuresFilters.metric((Metric)metric));
    }

    public Collection<Measure> getChildrenMeasures(MeasuresFilter filter) {
        ArrayList<Measure> result = new ArrayList<Measure>();
        for (DecoratorContext childContext : this.childrenContexts) {
            Object childResult = childContext.getMeasures(filter);
            if (childResult == null) continue;
            if (childResult instanceof Collection) {
                result.addAll((Collection)childResult);
                continue;
            }
            result.add((Measure)childResult);
        }
        return result;
    }

    public Collection<Measure> getChildrenMeasures(Metric metric) {
        return this.getChildrenMeasures(MeasuresFilters.metric((Metric)metric));
    }

    public Resource getResource() {
        return this.resource;
    }

    public DecoratorContext saveMeasure(Measure measure) {
        this.checkReadOnly("saveMeasure");
        this.index.saveMeasure(this.resource, measure);
        return this;
    }

    public DecoratorContext saveMeasure(Metric metric, Double value) {
        this.checkReadOnly("saveMeasure");
        this.index.saveMeasure(this.resource, new Measure(metric, value));
        return this;
    }

    public List<Violation> getViolations() {
        Bucket bucket;
        if (this.violations == null && (bucket = this.index.getBucket(this.resource)) != null && bucket.getSnapshotId() != null) {
            this.violations = this.violationsDao.getViolations(this.resource, bucket.getSnapshotId());
        }
        return this.violations;
    }

    public Dependency saveDependency(Dependency dependency) {
        this.checkReadOnly("saveDependency");
        return this.index.saveDependency(dependency);
    }

    public Set<Dependency> getDependencies() {
        return this.index.getDependencies();
    }

    public Collection<Dependency> getIncomingDependencies() {
        return this.index.getIncomingEdges(this.resource);
    }

    public Collection<Dependency> getOutgoingDependencies() {
        return this.index.getOutgoingEdges(this.resource);
    }

    protected DatabaseSession getSession() {
        return this.session;
    }

    public List<Event> getEvents() {
        return this.index.getEvents(this.resource);
    }

    public Event createEvent(String name, String description, String category, Date date) {
        return this.index.createEvent(this.resource, name, description, category, date);
    }

    public void deleteEvent(Event event) {
        this.index.deleteEvent(event);
    }

    public DefaultDecoratorContext saveViolation(Violation violation) {
        if (violation.getResource() == null) {
            violation.setResource(this.resource);
        }
        this.index.addViolation(violation);
        return this;
    }
}

