/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.metadata.ClassComponentDescriptorExtractor;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractor;
import org.codehaus.plexus.metadata.ComponentDescriptorWriter;
import org.codehaus.plexus.metadata.DefaultComponentDescriptorWriter;
import org.codehaus.plexus.metadata.MetadataGenerationRequest;
import org.codehaus.plexus.metadata.MetadataGenerator;
import org.codehaus.plexus.metadata.SourceComponentDescriptorExtractor;
import org.codehaus.plexus.metadata.gleaner.AnnotationComponentGleaner;
import org.codehaus.plexus.metadata.merge.Merger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

@Component(role=MetadataGenerator.class)
public class DefaultMetadataGenerator
extends AbstractLogEnabled
implements MetadataGenerator {
    @Requirement
    private Merger merger;
    private ComponentDescriptor<?>[] roleDefaults;
    private ComponentDescriptorExtractor[] extractors;
    private ComponentDescriptorWriter writer = new DefaultComponentDescriptorWriter();

    public void generateDescriptor(MetadataGenerationRequest request) throws Exception {
        assert (request.outputFile != null);
        if (this.extractors == null || this.extractors.length == 0) {
            this.extractors = new ComponentDescriptorExtractor[]{new SourceComponentDescriptorExtractor(), new ClassComponentDescriptorExtractor(new AnnotationComponentGleaner())};
        }
        ArrayList descriptors = new ArrayList();
        for (int i = 0; i < this.extractors.length; ++i) {
            try {
                List<ComponentDescriptor<?>> list = this.extractors[i].extract(request, this.roleDefaults);
                if (list == null || list.isEmpty()) continue;
                descriptors.addAll(list);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Failed to extract descriptors", e);
            }
        }
        ArrayList<File> componentDescriptors = new ArrayList<File>();
        if (descriptors.size() > 0) {
            this.getLogger().info("Discovered " + descriptors.size() + " component descriptors(s)");
            ComponentSetDescriptor set = new ComponentSetDescriptor();
            set.setComponents(descriptors);
            set.setDependencies(Collections.<ComponentDependency>emptyList());
            if (request.componentDescriptorDirectory == null) {
                this.writeDescriptor(set, request.outputFile);
            } else {
                if (request.intermediaryFile == null) {
                    request.intermediaryFile = File.createTempFile("plexus-metadata", "xml");
                    request.intermediaryFile.deleteOnExit();
                }
                this.writeDescriptor(set, request.intermediaryFile);
                componentDescriptors.add(request.intermediaryFile);
            }
        }
        if (request.componentDescriptorDirectory != null && request.componentDescriptorDirectory.isDirectory()) {
            File[] files;
            for (File file : files = request.componentDescriptorDirectory.listFiles()) {
                if (!file.getName().endsWith(".xml") || file.getName().equals("plexus.xml")) continue;
                componentDescriptors.add(file);
            }
        }
        if (componentDescriptors.size() > 0) {
            this.merger.mergeDescriptors(request.outputFile, componentDescriptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDescriptor(ComponentSetDescriptor desc, File outputFile) throws Exception {
        assert (desc != null);
        assert (outputFile != null);
        FileUtils.forceMkdir((File)outputFile.getParentFile());
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
        try {
            this.writer.writeDescriptorSet(output, desc, false);
            output.flush();
        }
        finally {
            IOUtil.close((Writer)output);
        }
        this.getLogger().debug("Wrote: " + outputFile);
    }
}

