/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import javax.annotation.WillClose;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ParallelScatterZipCreator;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipArchiveEntry;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipArchiveOutputStream;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipEncoding;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipEncodingHelper;
import org.codehaus.plexus.archiver.commonscompress.parallel.InputStreamSupplier;
import org.codehaus.plexus.archiver.util.ResourceUtils;
import org.codehaus.plexus.archiver.util.Streams;
import org.codehaus.plexus.archiver.zip.AnonymousResource;
import org.codehaus.plexus.components.io.functions.SymlinkDestinationSupplier;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractZipArchiver
extends AbstractArchiver {
    private String comment;
    private String encoding = "UTF8";
    private boolean doCompress = true;
    private boolean recompressAddedZips = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    protected String archiveType = "zip";
    private boolean doFilesonly = false;
    protected final Hashtable<String, String> entries = new Hashtable();
    protected final Hashtable<String, String> addedDirs = new Hashtable();
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    protected final String duplicate = "skip";
    protected boolean addingNewFiles = false;
    private static final boolean isJava7OrLower = Integer.parseInt(System.getProperty("java.version").split("\\.")[1]) <= 7;
    private File renamedFile = null;
    private File zipFile;
    private boolean success;
    private ParallelScatterZipCreator zOut;
    protected ZipArchiveOutputStream zipArchiveOutputStream;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCompress(boolean compress) {
        this.doCompress = compress;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public boolean isRecompressAddedZips() {
        return this.recompressAddedZips;
    }

    public void setRecompressAddedZips(boolean recompressAddedZips) {
        this.recompressAddedZips = recompressAddedZips;
    }

    public void setUpdateMode(boolean update) {
        this.savedDoUpdate = this.doUpdate = update;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void setFilesonly(boolean f) {
        this.doFilesonly = f;
    }

    public boolean isFilesonly() {
        return this.doFilesonly;
    }

    protected void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.createArchiveMain();
            this.skipWriting = false;
            this.createArchiveMain();
        } else {
            this.createArchiveMain();
        }
        this.finalizeZipOutputStream(this.zOut);
    }

    protected void finalizeZipOutputStream(ParallelScatterZipCreator zOut) throws IOException, ArchiverException {
    }

    private void createArchiveMain() throws ArchiverException, IOException {
        ResourceIterator iter;
        if (!"skip".equals("skip")) {
            this.setDuplicateBehavior("skip");
        }
        if (!(iter = this.getResources()).hasNext() && !this.hasVirtualFiles()) {
            throw new ArchiverException("You must set at least one file.");
        }
        this.zipFile = this.getDestFile();
        if (this.zipFile == null) {
            throw new ArchiverException("You must set the destination " + this.archiveType + "file.");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new ArchiverException(this.zipFile + " isn't a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new ArchiverException(this.zipFile + " is read-only.");
        }
        this.addingNewFiles = true;
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.getLogger().debug("ignoring update attribute as " + this.archiveType + " doesn't exist.");
        }
        this.success = false;
        if (this.doUpdate) {
            this.renamedFile = FileUtils.createTempFile((String)"zip", (String)".tmp", (File)this.zipFile.getParentFile());
            this.renamedFile.deleteOnExit();
            try {
                FileUtils.rename((File)this.zipFile, (File)this.renamedFile);
            }
            catch (SecurityException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
            catch (IOException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
        }
        String action = this.doUpdate ? "Updating " : "Building ";
        this.getLogger().info(action + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        if (!this.skipWriting) {
            this.zipArchiveOutputStream = new ZipArchiveOutputStream(Streams.bufferedOutputStream(Streams.fileOutputStream(this.zipFile, "zip")));
            this.zipArchiveOutputStream.setEncoding(this.encoding);
            this.zipArchiveOutputStream.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            this.zipArchiveOutputStream.setMethod(this.doCompress ? 8 : 0);
            this.zOut = new ParallelScatterZipCreator();
        }
        this.initZipOutputStream(this.zOut);
        this.addResources(iter, this.zOut);
        if (this.doUpdate && !this.renamedFile.delete()) {
            this.getLogger().warn("Warning: unable to delete temporary file " + this.renamedFile.getName());
        }
        this.success = true;
    }

    protected final void addResources(ResourceIterator resources, ParallelScatterZipCreator zOut) throws IOException, ArchiverException {
        while (resources.hasNext()) {
            ArchiveEntry entry = resources.next();
            String name = entry.getName();
            if ("".equals(name = name.replace(File.separatorChar, '/'))) continue;
            if (entry.getResource().isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            this.addParentDirs(entry, null, name, zOut, "");
            if (entry.getResource().isFile()) {
                this.zipFile(entry, zOut, name);
                continue;
            }
            this.zipDir(entry.getResource(), zOut, name, entry.getMode(), this.encoding);
        }
    }

    private void addParentDirs(ArchiveEntry archiveEntry, File baseDir, String entry, ParallelScatterZipCreator zOut, String prefix) throws IOException {
        if (!this.doFilesonly && this.getIncludeEmptyDirs()) {
            String dir;
            Stack<String> directories = new Stack<String>();
            int slashPos = entry.length() - (entry.endsWith("/") ? 1 : 0);
            while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
                dir = entry.substring(0, slashPos + 1);
                if (this.addedDirs.contains(prefix + dir)) break;
                directories.push(dir);
            }
            while (!directories.isEmpty()) {
                dir = (String)directories.pop();
                File f = baseDir != null ? new File(baseDir, dir) : new File(dir);
                AnonymousResource res = new AnonymousResource(f);
                this.zipDir((PlexusIoResource)res, zOut, prefix + dir, archiveEntry.getDefaultDirMode(), this.encoding);
            }
        }
    }

    protected void zipFile(@WillClose InputStream in, ParallelScatterZipCreator zOut, String vPath, long lastModified, File fromArchive, int mode, String symlinkDestination) throws IOException, ArchiverException {
        this.getLogger().debug("adding entry " + vPath);
        this.entries.put(vPath, vPath);
        if (!this.skipWriting) {
            InputStream payload;
            ZipArchiveEntry ze = new ZipArchiveEntry(vPath);
            this.setTime(ze, lastModified);
            byte[] header = new byte[4];
            int read = in.read(header);
            boolean compressThis = this.doCompress;
            if (!this.recompressAddedZips && this.isZipHeader(header)) {
                compressThis = false;
            }
            ze.setMethod(compressThis ? 8 : 0);
            ze.setUnixMode(0x8000 | mode);
            if (ze.isUnixSymlink()) {
                ZipEncoding enc = ZipEncodingHelper.getZipEncoding(this.getEncoding());
                byte[] bytes = enc.encode(symlinkDestination).array();
                payload = new ByteArrayInputStream(bytes);
            } else {
                payload = this.maybeSequence(header, read, in);
            }
            zOut.addArchiveEntry(ze, this.createInputStreamSupplier(payload));
        }
    }

    private InputStream maybeSequence(byte[] header, int hdrBytes, InputStream in) {
        return hdrBytes > 0 ? new SequenceInputStream(new ByteArrayInputStream(header, 0, hdrBytes), in) : in;
    }

    private boolean isZipHeader(byte[] header) {
        return header[0] == 80 && header[1] == 75 && header[2] == 3 && header[3] == 4;
    }

    protected void zipFile(ArchiveEntry entry, ParallelScatterZipCreator zOut, String vPath) throws IOException, ArchiverException {
        PlexusIoResource resource = entry.getResource();
        if (ResourceUtils.isSame(resource, this.getDestFile())) {
            throw new ArchiverException("A zip file cannot include itself");
        }
        boolean b = entry.getResource() instanceof SymlinkDestinationSupplier;
        String symlinkTarget = b ? ((SymlinkDestinationSupplier)entry.getResource()).getSymlinkDestination() : null;
        InputStream in = entry.getInputStream();
        try {
            this.zipFile(in, zOut, vPath, resource.getLastModified(), null, entry.getMode(), symlinkTarget);
        }
        catch (IOException e) {
            throw new ArchiverException("IOException when zipping r" + entry.getName() + ": " + e.getMessage(), e);
        }
    }

    private void setTime(ZipEntry zipEntry, long lastModified) {
        zipEntry.setTime(lastModified + (long)(isJava7OrLower ? 1999 : 0));
    }

    protected void zipDir(PlexusIoResource dir, ParallelScatterZipCreator zOut, String vPath, int mode, String encodingToUse) throws IOException {
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.getLogger().debug("adding directory " + vPath);
        this.addedDirs.put(vPath, vPath);
        if (!this.skipWriting) {
            boolean isSymlink = dir instanceof SymlinkDestinationSupplier;
            if (isSymlink && vPath.endsWith(File.separator)) {
                vPath = vPath.substring(0, vPath.length() - 1);
            }
            ZipArchiveEntry ze = new ZipArchiveEntry(vPath);
            if (isSymlink) {
                mode = 0xA000 | mode;
            }
            if (dir != null && dir.isExisting()) {
                this.setTime(ze, dir.getLastModified());
            } else {
                this.setTime(ze, System.currentTimeMillis());
            }
            if (!isSymlink) {
                ze.setSize(0L);
                ze.setMethod(0);
                ze.setCrc(EMPTY_CRC);
            }
            ze.setUnixMode(mode);
            if (!isSymlink) {
                zOut.addArchiveEntry(ze, this.createInputStreamSupplier(new ByteArrayInputStream("".getBytes())));
            } else {
                String symlinkDestination = ((SymlinkDestinationSupplier)dir).getSymlinkDestination();
                ZipEncoding enc = ZipEncodingHelper.getZipEncoding(encodingToUse);
                byte[] bytes = enc.encode(symlinkDestination).array();
                ze.setMethod(8);
                zOut.addArchiveEntry(ze, this.createInputStreamSupplier(new ByteArrayInputStream(bytes)));
            }
        }
    }

    private InputStreamSupplier createInputStreamSupplier(final InputStream inputStream) {
        return new InputStreamSupplier(){

            public InputStream get() {
                return inputStream;
            }
        };
    }

    protected boolean createEmptyZip(File zipFile) throws ArchiverException {
        this.getLogger().info("Note: creating empty " + this.archiveType + " archive " + zipFile);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(zipFile);
            byte[] empty = new byte[22];
            empty[0] = 80;
            empty[1] = 75;
            empty[2] = 5;
            empty[3] = 6;
            ((OutputStream)os).write(empty);
        }
        catch (IOException ioe) {
            try {
                throw new ArchiverException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)os);
        return true;
    }

    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.addedDirs.clear();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        this.success = false;
        this.zOut = null;
        this.renamedFile = null;
        this.zipFile = null;
    }

    public void reset() {
        this.setDestFile(null);
        this.archiveType = "zip";
        this.doCompress = true;
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected void initZipOutputStream(ParallelScatterZipCreator zOut) throws ArchiverException, IOException {
    }

    public boolean isSupportingForced() {
        return true;
    }

    protected boolean revert(StringBuffer messageBuffer) {
        int initLength = messageBuffer.length();
        if (!(this.doUpdate && this.renamedFile == null || this.zipFile.delete())) {
            messageBuffer.append(" (and the archive is probably corrupt but I could not delete it)");
        }
        if (this.doUpdate && this.renamedFile != null) {
            try {
                FileUtils.rename((File)this.renamedFile, (File)this.zipFile);
            }
            catch (IOException e) {
                messageBuffer.append(" (and I couldn't rename the temporary file ");
                messageBuffer.append(this.renamedFile.getName());
                messageBuffer.append(" back)");
            }
        }
        return messageBuffer.length() == initLength;
    }

    protected void close() throws IOException {
        try {
            if (this.zipArchiveOutputStream != null) {
                this.zOut.writeTo(this.zipArchiveOutputStream);
                this.zipArchiveOutputStream.close();
            }
        }
        catch (IOException ex) {
            if (this.success) {
                throw ex;
            }
        }
        catch (InterruptedException e) {
            IOException ex = new IOException("InterruptedException exception");
            ex.initCause(e.getCause());
            throw ex;
        }
        catch (ExecutionException e) {
            IOException ex = new IOException("Execution exception");
            ex.initCause(e.getCause());
            throw ex;
        }
    }

    protected String getArchiveType() {
        return this.archiveType;
    }
}

