/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xslt;

import java.io.File;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class XsltMojo
extends AbstractMojo {
    private File xslFile;
    private File srcDir;
    private String srcIncludes;
    private String srcExcludes;
    private File destDir;
    private String fileNameRegex;
    private String fileNameReplacement;

    public void execute() throws MojoExecutionException {
        try {
            if (!this.xslFile.exists()) {
                this.getLog().error((CharSequence)("XSL file does not exist: " + this.xslFile));
                return;
            }
            if (!this.srcDir.exists()) {
                this.getLog().error((CharSequence)("Source directory does not exist: " + this.srcDir));
                return;
            }
            if (!this.destDir.exists()) {
                this.destDir.mkdirs();
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(this.xslFile));
            String[] xmlFiles = this.getIncludedFiles(this.srcDir, this.srcIncludes, this.srcExcludes);
            this.getLog().info((CharSequence)("# of XML files: " + xmlFiles.length));
            for (int i = 0; i < xmlFiles.length; ++i) {
                File destFile;
                File srcFile = new File(this.srcDir, xmlFiles[i]);
                String destFileName = xmlFiles[i];
                if (this.fileNameRegex != null && this.fileNameReplacement != null) {
                    destFileName = destFileName.replaceAll(this.fileNameRegex, this.fileNameReplacement);
                }
                if ((destFile = new File(this.destDir, destFileName)).exists() && srcFile.lastModified() < destFile.lastModified()) {
                    this.getLog().info((CharSequence)("file up-to-date: " + destFile));
                    continue;
                }
                this.getLog().info((CharSequence)("transform, srcFile: " + srcFile + ", destFile: " + destFile));
                transformer.transform(new StreamSource(srcFile), new StreamResult(destFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getIncludedFiles(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        if (excludes != null) {
            scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        }
        scanner.scan();
        String[] filesToFormat = scanner.getIncludedFiles();
        return filesToFormat;
    }
}

