/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip;

import de.schlichtherle.io.File;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.truezip.AbstractManipulateArchiveMojo;
import org.codehaus.mojo.truezip.Fileset;
import org.codehaus.plexus.util.StringUtils;

public class MoveMojo
extends AbstractManipulateArchiveMojo {
    private String from;
    private String to;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!StringUtils.isBlank((String)this.from)) {
            File file = new File(this.resolveRelativePath(this.from));
            if (StringUtils.isBlank((String)this.from)) {
                throw new MojoExecutionException("You have specified 'from' configuration to perform the move, but 'to' configuration is not available. ");
            }
            File tofile = new File(this.resolveRelativePath(this.to));
            this.truezip.moveFile(file, tofile);
        }
        if (this.fileset != null) {
            this.filesets.add(this.fileset);
            this.fileset = null;
        }
        Iterator it = this.filesets.iterator();
        while (it.hasNext()) {
            Fileset oneFileSet = (Fileset)((Object)it.next());
            try {
                this.resolveRelativePath(oneFileSet);
                this.truezip.move(oneFileSet, this.verbose, this.getLog());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Move fileset fails", e);
            }
        }
        this.tryImmediateUpdate();
    }
}

