/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.shade.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.codehaus.mojo.shade.resource.ResourceTransformer;

public class ApacheNoticeResourceTransformer
implements ResourceTransformer {
    Set entries = new HashSet();
    String projectName;
    String preamble1 = "// ------------------------------------------------------------------\n// NOTICE file corresponding to the section 4d of The Apache License,\n// Version 2.0, in this case for ";
    String preamble2 = "\n// ------------------------------------------------------------------\n\n";
    String preamble3 = "This product includes software developed at\nApache Software Foundation (http://www.apache.org/).\n";
    String copyright;

    public boolean canTransformResource(String resource) {
        String s = resource.toLowerCase();
        return s.equals("meta-inf/notice.txt") || s.equals("meta-inf/notice");
    }

    public void processResource(InputStream is) throws IOException {
        this.copyright = this.projectName + "\nCopyright 2006-2007 Apache Software Foundation\n";
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = reader.readLine();
        StringBuffer sb = new StringBuffer();
        while (line != null) {
            if (!(line = line.trim()).startsWith("//")) {
                if (line.length() > 0) {
                    sb.append(line).append("\n");
                } else {
                    this.entries.add(sb.toString());
                    sb = new StringBuffer();
                }
            }
            line = reader.readLine();
        }
        this.entries.remove(this.preamble3);
        this.entries.remove(this.copyright);
    }

    public boolean hasTransformedResource() {
        return true;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        jos.putNextEntry(new JarEntry("META-INF/NOTICE"));
        OutputStreamWriter writer = new OutputStreamWriter(jos);
        writer.write(this.preamble1);
        writer.write(this.projectName);
        writer.write(this.preamble2);
        writer.write(this.copyright);
        writer.write("\n");
        writer.write(this.preamble3);
        writer.write("\n");
        Iterator itr = this.entries.iterator();
        while (itr.hasNext()) {
            String line = (String)itr.next();
            ((Writer)writer).append(line);
            writer.append('\n');
        }
        writer.flush();
    }
}

