/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.shade.mojo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.shade.Shader;
import org.codehaus.mojo.shade.mojo.ArtifactSet;
import org.codehaus.mojo.shade.mojo.PackageRelocation;
import org.codehaus.mojo.shade.pom.PomWriter;
import org.codehaus.mojo.shade.relocation.SimpleRelocator;
import org.codehaus.mojo.shade.resource.ResourceTransformer;

public class ShadeMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private Shader shader;
    private ArtifactSet artifactSet;
    private PackageRelocation[] relocations;
    private ResourceTransformer[] transformers;
    private File outputDirectory;
    private String finalName;
    private String shadedArtifactId;
    private String shadedGroupFilter;
    private boolean shadedArtifactAttached;
    private boolean createDependencyReducedPom;
    private boolean keepDependenciesWithProvidedScope;
    private String shadedClassifierName;

    public void execute() throws MojoExecutionException {
        HashSet<File> artifacts = new HashSet<File>();
        HashSet<String> artifactIds = new HashSet<String>();
        Iterator it = this.project.getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (this.excludeArtifact(artifact)) {
                this.getLog().info((CharSequence)("Excluding " + artifact.getId() + " from the shaded jar."));
                continue;
            }
            this.getLog().info((CharSequence)("Including " + artifact.getId() + " in the shaded jar."));
            artifacts.add(artifact.getFile());
            artifactIds.add(this.getId(artifact));
        }
        artifacts.add(this.project.getArtifact().getFile());
        File outputJar = this.shadedArtifactFileWithClassifier();
        try {
            List relocators = this.getRelocators();
            List resourceTransformers = this.getResourceTrasformers();
            this.shader.shade(artifacts, outputJar, relocators, resourceTransformers);
            if (this.shadedArtifactAttached) {
                this.getLog().info((CharSequence)"Attaching shaded artifact.");
                this.projectHelper.attachArtifact(this.getProject(), "jar", this.shadedClassifierName, outputJar);
            } else {
                this.getLog().info((CharSequence)"Replacing original artifact with shaded artifact.");
                File file = this.shadedArtifactFile();
                file.renameTo(new File(this.outputDirectory, "original-" + file.getName()));
                if (!outputJar.renameTo(file)) {
                    this.getLog().warn((CharSequence)"Could not replace original artifact with shaded artifact!");
                }
                if (this.createDependencyReducedPom) {
                    this.createDependencyReducedPom(artifactIds);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating shaded jar.", (Exception)e);
        }
    }

    private boolean excludeArtifact(Artifact artifact) {
        String id = this.getId(artifact);
        if (this.artifactSet != null && this.artifactSet.getExcludes() == null && this.artifactSet.getIncludes() != null && !this.includedArtifacts().contains(id)) {
            return true;
        }
        if (this.excludedArtifacts().contains(id)) {
            return true;
        }
        return this.shadedGroupFilter != null && !artifact.getGroupId().startsWith(this.shadedGroupFilter);
    }

    private Set excludedArtifacts() {
        if (this.artifactSet != null && this.artifactSet.getExcludes() != null) {
            return this.artifactSet.getExcludes();
        }
        return Collections.EMPTY_SET;
    }

    private Set includedArtifacts() {
        if (this.artifactSet != null && this.artifactSet.getIncludes() != null) {
            return this.artifactSet.getIncludes();
        }
        return Collections.EMPTY_SET;
    }

    private List getRelocators() {
        ArrayList<SimpleRelocator> relocators = new ArrayList<SimpleRelocator>();
        if (this.relocations == null) {
            return relocators;
        }
        for (int i = 0; i < this.relocations.length; ++i) {
            PackageRelocation r = this.relocations[i];
            if (r.getExcludes() != null) {
                relocators.add(new SimpleRelocator(r.getPattern(), r.getExcludes()));
                continue;
            }
            relocators.add(new SimpleRelocator(r.getPattern(), null));
        }
        return relocators;
    }

    private List getResourceTrasformers() {
        if (this.transformers == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.transformers);
    }

    private File shadedArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "." + artifact.getType();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.finalName != null ? this.finalName + "." + artifact.getType() : this.shadedArtifactId + "-" + artifact.getVersion() + "." + artifact.getType();
        return new File(this.outputDirectory, shadedName);
    }

    protected MavenProject getProject() {
        if (this.project.getExecutionProject() != null) {
            return this.project.getExecutionProject();
        }
        return this.project;
    }

    private void createDependencyReducedPom(Set artifactsToRemove) throws IOException {
        Model model = this.getProject().getOriginalModel();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        boolean modified = false;
        Iterator i = model.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency d = (Dependency)i.next();
            dependencies.add(d);
            String id = d.getGroupId() + ":" + d.getArtifactId();
            if (!artifactsToRemove.contains(id)) continue;
            modified = true;
            if (this.keepDependenciesWithProvidedScope) {
                d.setScope("provided");
                continue;
            }
            dependencies.remove(d);
        }
        if (modified) {
            model.setDependencies(dependencies);
            File f = new File(this.getProject().getFile().getParentFile(), "dependency-reduced-pom.xml");
            f.deleteOnExit();
            FileWriter w = new FileWriter(f);
            PomWriter.write(w, model, true);
            ((Writer)w).close();
            this.getProject().setFile(f);
        }
    }

    private String getId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }
}

